/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.htsgetreader;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.htsgetreader.HtsgetClass;
import org.broadinstitute.hellbender.tools.htsgetreader.HtsgetFormat;
import org.broadinstitute.hellbender.utils.HttpUtils;
import org.broadinstitute.hellbender.utils.io.IOUtils;

@JsonRootName(value="htsget")
public class HtsgetResponse {
    @JsonProperty(value="format")
    private HtsgetFormat format;
    @JsonProperty(value="urls")
    @JsonDeserialize(as=ArrayList.class, contentAs=Block.class)
    private List<Block> blocks;
    @JsonProperty(value="md5")
    private String md5;

    public HtsgetFormat getFormat() {
        return this.format;
    }

    public List<Block> getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }

    public String getMd5() {
        return this.md5;
    }

    public static class Block {
        @JsonProperty(value="url")
        private URI uri;
        @JsonProperty(value="headers")
        @JsonDeserialize(as=HashMap.class, keyAs=String.class, contentAs=String.class)
        private Map<String, String> headers;
        @JsonProperty(value="class")
        private HtsgetClass dataClass;

        public URI getUri() {
            return this.uri;
        }

        public Map<String, String> getHeaders() {
            return Collections.unmodifiableMap(this.headers);
        }

        public HtsgetClass getDataClass() {
            return this.dataClass;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public InputStream getData() {
            switch (this.getUri().getScheme()) {
                case "http": 
                case "https": {
                    HttpGet get = new HttpGet(this.getUri());
                    this.getHeaders().forEach((arg_0, arg_1) -> ((HttpGet)get).addHeader(arg_0, arg_1));
                    try (CloseableHttpResponse resp = HttpUtils.getClient().execute((HttpUriRequest)get);){
                        Path outputFile = IOUtils.createTempPath("htsget-temp", "");
                        try (OutputStream ostream = Files.newOutputStream(outputFile, new OpenOption[0]);
                             InputStream istream = resp.getEntity().getContent();){
                            org.apache.commons.io.IOUtils.copy((InputStream)istream, (OutputStream)ostream);
                        }
                        catch (IOException e) {
                            throw new UserException("Could not write to temp file", e);
                        }
                        InputStream inputStream = Files.newInputStream(outputFile, new OpenOption[0]);
                        return inputStream;
                    }
                    catch (IOException e) {
                        throw new UserException("Could not retrieve data from block", e);
                    }
                }
                case "data": {
                    String dataUri = this.getUri().toString();
                    if (dataUri.matches("^data:.*;base64,.*")) return new ByteArrayInputStream(Base64.getDecoder().decode(dataUri.replaceFirst("^data:.*;base64,", "")));
                    throw new UserException("data URI must be base64 encoded: " + dataUri);
                }
            }
            throw new UserException("Unrecognized URI scheme in data block: " + this.getUri().getScheme());
        }
    }
}

