/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.readersplitters;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.tools.readersplitters.ReaderSplitter;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public abstract class ReadGroupSplitter<T>
extends ReaderSplitter<T> {
    @Override
    public T getSplitBy(GATKRead record, SAMFileHeader header) {
        return this.getSplitByFunction().apply(ReadUtils.getSAMReadGroupRecord(record, header));
    }

    @Override
    public List<T> getSplitsBy(SAMFileHeader header) {
        return header.getReadGroups().stream().map(this.getSplitByFunction()).collect(Collectors.toList());
    }

    protected abstract Function<SAMReadGroupRecord, T> getSplitByFunction();
}

