/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark;

import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.tools.ApplyBQSRArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.transforms.ApplyBQSRSparkFn;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationReport;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Apply a linear base quality recalibration model trained with the BaseRecalibrator tool on Spark.", oneLineSummary="Apply base quality score recalibration on Spark", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
@BetaFeature
public final class ApplyBQSRSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 0L;
    static final String USAGE_ONE_LINE_SUMMARY = "Apply base quality score recalibration on Spark";
    static final String USAGE_SUMMARY = "Apply a linear base quality recalibration model trained with the BaseRecalibrator tool on Spark.";
    @Argument(doc="the output bam", shortName="O", fullName="output", optional=false)
    private String output;
    @Argument(fullName="bqsr-recal-file", shortName="bqsr", doc="Input covariates table file for base quality score recalibration")
    private String bqsrRecalFile;
    @ArgumentCollection
    private ApplyBQSRArgumentCollection applyBQSRArgs = new ApplyBQSRArgumentCollection();

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        JavaRDD<GATKRead> initialReads = this.getReads();
        Broadcast recalibrationReportBroadCast = ctx.broadcast((Object)new RecalibrationReport(BucketUtils.openFile(this.bqsrRecalFile)));
        JavaRDD<GATKRead> recalibratedReads = ApplyBQSRSparkFn.apply(initialReads, (Broadcast<RecalibrationReport>)recalibrationReportBroadCast, this.getHeaderForReads(), this.applyBQSRArgs);
        this.writeReads(ctx, this.output, recalibratedReads);
    }
}

