/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark;

import java.io.PrintStream;
import java.util.List;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.tools.spark.transforms.BaseRecalibratorSparkFn;
import org.broadinstitute.hellbender.tools.walkers.bqsr.BaseRecalibrator;
import org.broadinstitute.hellbender.utils.SerializableFunction;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.recalibration.BaseRecalibrationEngine;
import org.broadinstitute.hellbender.utils.recalibration.RecalUtils;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationArgumentCollection;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationReport;
import org.broadinstitute.hellbender.utils.spark.JoinReadsWithVariants;
import org.broadinstitute.hellbender.utils.variant.GATKVariant;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="First pass of the Base Quality Score Recalibration (BQSR) on Spark. Generate a recalibration table based on various user-specified covariates (such as read group, reported quality score, machine cycle, and nucleotide context).", oneLineSummary="Generate recalibration table for Base Quality Score Recalibration (BQSR) on Spark", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
@BetaFeature
public class BaseRecalibratorSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    static final String USAGE_ONE_LINE_SUMMARY = "Generate recalibration table for Base Quality Score Recalibration (BQSR) on Spark";
    static final String USAGE_SUMMARY = "First pass of the Base Quality Score Recalibration (BQSR) on Spark. Generate a recalibration table based on various user-specified covariates (such as read group, reported quality score, machine cycle, and nucleotide context).";
    @Argument(doc="the known variants", fullName="known-sites", optional=false)
    private List<String> knownVariants;
    @Argument(doc="Path to save the final recalibration tables to.", shortName="O", fullName="output", optional=false)
    private String outputTablesPath = null;
    @ArgumentCollection(doc="all the command line arguments for BQSR and its covariates")
    private final RecalibrationArgumentCollection bqsrArgs = new RecalibrationArgumentCollection();

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public SerializableFunction<GATKRead, SimpleInterval> getReferenceWindowFunction() {
        return BaseRecalibrationEngine.BQSR_REFERENCE_WINDOW_FUNCTION;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return BaseRecalibrator.getStandardBQSRReadFilterList();
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        String referenceFileName = BaseRecalibratorSpark.addReferenceFilesForSpark(ctx, this.referenceArguments.getReferencePath());
        List<String> localKnownSitesFilePaths = BaseRecalibratorSpark.addVCFsForSpark(ctx, this.knownVariants);
        JavaPairRDD<GATKRead, Iterable<GATKVariant>> readsWithVariants = JoinReadsWithVariants.join(this.getReads(), localKnownSitesFilePaths);
        RecalibrationReport bqsrReport = BaseRecalibratorSparkFn.apply(readsWithVariants, this.getHeaderForReads(), referenceFileName, this.bqsrArgs);
        try (PrintStream reportStream = new PrintStream(BucketUtils.createFile(this.outputTablesPath));){
            RecalUtils.outputRecalibrationReport(reportStream, this.bqsrArgs, bqsrReport.getQuantizationInfo(), bqsrReport.getRecalibrationTables(), bqsrReport.getCovariates());
        }
    }
}

