/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndexer;
import htsjdk.samtools.BAMSBIIndexer;
import htsjdk.samtools.BamFileIoUtils;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SBIIndexWriter;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.read.ReadConstants;
import org.codehaus.plexus.util.FileUtils;
import picard.cmdline.programgroups.OtherProgramGroup;

@CommandLineProgramProperties(summary="Create a Hadoop BAM splitting index and optionally a BAM index from a BAM file", oneLineSummary="Create a Hadoop BAM splitting index", programGroup=OtherProgramGroup.class)
@DocumentedFeature
@BetaFeature
public final class CreateHadoopBamSplittingIndex
extends CommandLineProgram {
    private static final Logger logger = LogManager.getLogger(CreateHadoopBamSplittingIndex.class);
    public static final String SPLITTING_INDEX_GRANULARITY_LONG_NAME = "splitting-index-granularity";
    public static final String CREATE_BAI_LONG_NAME = "create-bai";
    @Argument(fullName="input", shortName="I", doc="BAM file to create a HadoopBam splitting index for", optional=false)
    public File inputBam;
    @Argument(fullName="read-validation-stringency", shortName="VS", doc="Validation stringency for all SAM/BAM/CRAM/SRA files read by this program.  The default stringency value SILENT can improve performance when processing a BAM file in which variable-length data (read, qualities, tags) do not otherwise need to be decoded.", common=true, optional=true)
    public ValidationStringency readValidationStringency = ReadConstants.DEFAULT_READ_VALIDATION_STRINGENCY;
    @Argument(fullName="output", shortName="O", doc="The splitting index (SBI) file. If this is unspecified an index will be created with the same name as the input file but with the additional extension .sbi", optional=true)
    public File output;
    @Argument(fullName="splitting-index-granularity", doc="Splitting index granularity, an entry is created in the index every this many reads.", optional=true)
    public long granularity = 4096L;
    @Argument(fullName="create-bai", doc="Set this to create a bai index at the same time as creating a splitting index", optional=true)
    public boolean createBai = false;

    @Override
    public Object doWork() {
        if (this.granularity <= 0L) {
            throw new CommandLineException.BadArgumentValue(SPLITTING_INDEX_GRANULARITY_LONG_NAME, Long.toString(this.granularity), "Granularity must be > 0");
        }
        File index = CreateHadoopBamSplittingIndex.getOutputFile(this.output, this.inputBam);
        if (this.createBai) {
            CreateHadoopBamSplittingIndex.createBaiAndSplittingIndex(this.inputBam, index, this.granularity, this.readValidationStringency);
        } else {
            CreateHadoopBamSplittingIndex.createOnlySplittingIndex(this.inputBam, index, this.granularity);
        }
        return 0;
    }

    private static void createOnlySplittingIndex(File inputBam, File index, long granularity) {
        CreateHadoopBamSplittingIndex.assertIsBam(inputBam);
        try (SeekableFileStream in = new SeekableFileStream(inputBam);
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(index));){
            BAMSBIIndexer.createIndex((SeekableStream)in, (OutputStream)out, (long)granularity);
        }
        catch (IOException e) {
            throw new UserException("Couldn't create splitting index", e);
        }
    }

    private static void createBaiAndSplittingIndex(File inputBam, File index, long granularity, ValidationStringency readValidationStringency) {
        CreateHadoopBamSplittingIndex.assertIsBam(inputBam);
        try (SamReader reader = SamReaderFactory.makeDefault().validationStringency(readValidationStringency).setOption(SamReaderFactory.Option.INCLUDE_SOURCE_IN_RECORDS, true).open(inputBam);
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(index));){
            SAMFileHeader header = reader.getFileHeader();
            CreateHadoopBamSplittingIndex.assertBamIsCoordinateSorted(header);
            SBIIndexWriter indexer = new SBIIndexWriter((OutputStream)out, granularity);
            BAMIndexer bamIndexer = new BAMIndexer(IOUtils.replaceExtension(index, ".bai"), header);
            BAMFileSpan lastFilePointer = null;
            for (SAMRecord read : reader) {
                BAMFileSpan filePointer = (BAMFileSpan)read.getFileSource().getFilePointer();
                indexer.processRecord(filePointer.getFirstOffset());
                bamIndexer.processAlignment(read);
                lastFilePointer = filePointer;
            }
            long nextStart = 0L;
            if (lastFilePointer != null && !lastFilePointer.getChunks().isEmpty()) {
                nextStart = ((Chunk)lastFilePointer.getChunks().get(0)).getChunkEnd();
            }
            if (nextStart == 0L) {
                nextStart = BlockCompressedFilePointerUtil.makeFilePointer((long)inputBam.length());
            }
            indexer.finish(nextStart, inputBam.length());
            bamIndexer.finish();
        }
        catch (IOException e) {
            throw new UserException("Couldn't create splitting index", e);
        }
    }

    private static void assertBamIsCoordinateSorted(SAMFileHeader header) {
        if (header.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new UserException.BadInput("Cannot create a .bai index for a file that isn't coordinate sorted.");
        }
    }

    private static void assertIsBam(File inputBam) {
        if (!BamFileIoUtils.isBamFile((File)inputBam)) {
            throw new UserException.BadInput("A splitting index is only relevant for a bam file, but a file with extension " + FileUtils.getExtension((String)inputBam.getName()) + " was specified.");
        }
    }

    private static File getOutputFile(File suggestedOutput, File input) {
        if (suggestedOutput == null) {
            return new File(input.getPath() + ".sbi");
        }
        if (!suggestedOutput.getAbsolutePath().endsWith("bam.sbi")) {
            logger.warn("Creating a splitting index (SBI) with an extension that doesn't match bam.sbi.  Output file: " + suggestedOutput);
        }
        return suggestedOutput;
    }
}

