/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark;

import htsjdk.tribble.Feature;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.CoverageAnalysisProgramGroup;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.engine.filters.WellformedReadFilter;
import org.broadinstitute.hellbender.engine.spark.LocusWalkerContext;
import org.broadinstitute.hellbender.engine.spark.LocusWalkerSpark;
import org.broadinstitute.hellbender.utils.pileup.PileupElement;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;

@CommandLineProgramProperties(summary="Prints read alignments in samtools pileup format. The tool leverages the Spark framework for faster operationThe output comprises one line per genomic position, listing the chromosome name, coordinate, reference base, read bases, and read qualities. In addition to these default fields, additional information can be added to the output as extra columns.", oneLineSummary="Prints read alignments in samtools pileup format", programGroup=CoverageAnalysisProgramGroup.class)
@DocumentedFeature
@BetaFeature
public final class PileupSpark
extends LocusWalkerSpark {
    private static final long serialVersionUID = 1L;
    private static final String VERBOSE_DELIMITER = "@";
    @Argument(shortName="O", fullName="output", doc="The output directory to which the scattered output will be written.")
    protected String outputFile;
    @Argument(fullName="show-verbose", shortName="verbose", doc="Add extra informative columns to the pileup output. The verbose output contains the number of spanning deletions, and for each read in the pileup it has the read name, offset in the base string, read length, and read mapping quality.  These per read items are delimited with an '@' character.", optional=true)
    public boolean showVerbose = false;
    @Argument(fullName="metadata", shortName="metadata", doc="Features file(s) containing metadata. The overlapping sites will be annotated with the corresponding source Feature identifier.", optional=true)
    public List<FeatureInput<Feature>> metadata = new ArrayList<FeatureInput<Feature>>();
    @Argument(fullName="output-insert-length", shortName="output-insert-length", doc="If enabled, inserts lengths will be added to the output pileup.", optional=true)
    public boolean outputInsertLength = false;

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        ArrayList<ReadFilter> filterList = new ArrayList<ReadFilter>(5);
        filterList.add(ReadFilterLibrary.MAPPED);
        filterList.add(ReadFilterLibrary.NOT_DUPLICATE);
        filterList.add(ReadFilterLibrary.PASSES_VENDOR_QUALITY_CHECK);
        filterList.add(ReadFilterLibrary.NOT_SECONDARY_ALIGNMENT);
        filterList.add(new WellformedReadFilter());
        return filterList;
    }

    @Override
    protected void processAlignments(JavaRDD<LocusWalkerContext> rdd, JavaSparkContext ctx) {
        JavaRDD lines = rdd.map(PileupSpark.pileupFunction(this.metadata, this.outputInsertLength, this.showVerbose));
        if (this.numReducers != 0) {
            lines = lines.coalesce(this.numReducers);
        }
        lines.saveAsTextFile(this.outputFile);
    }

    private static Function<LocusWalkerContext, String> pileupFunction(List<FeatureInput<Feature>> metadata, boolean outputInsertLength, boolean showVerbose) {
        return (Function & Serializable)context -> {
            AlignmentContext alignmentContext = context.getAlignmentContext();
            ReferenceContext referenceContext = context.getReferenceContext();
            FeatureContext featureContext = context.getFeatureContext();
            String features = PileupSpark.getFeaturesString(featureContext, metadata);
            ReadPileup basePileup = alignmentContext.getBasePileup();
            StringBuilder s = new StringBuilder();
            s.append(String.format("%s %s", basePileup.getPileupString(referenceContext.hasBackingDataSource() ? (char)referenceContext.getBase() : (char)'N'), features));
            if (outputInsertLength) {
                s.append(" ").append(PileupSpark.insertLengthOutput(basePileup));
            }
            if (showVerbose) {
                s.append(" ").append(PileupSpark.createVerboseOutput(basePileup));
            }
            s.append("\n");
            return s.toString();
        };
    }

    private static String getFeaturesString(FeatureContext featureContext, List<FeatureInput<Feature>> metadata) {
        String featuresString = featureContext.getValues(metadata).stream().map(Object::toString).collect(Collectors.joining(", "));
        if (!featuresString.isEmpty()) {
            featuresString = "[Feature(s): " + featuresString + "]";
        }
        return featuresString;
    }

    private static String insertLengthOutput(ReadPileup pileup) {
        return pileup.getReads().stream().map(r -> String.valueOf(r.getFragmentLength())).collect(Collectors.joining(","));
    }

    private static String createVerboseOutput(ReadPileup pileup) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        sb.append(pileup.getNumberOfElements(PileupElement::isDeletion));
        sb.append(" ");
        for (PileupElement p : pileup) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(p.getRead().getName());
            sb.append(VERBOSE_DELIMITER);
            sb.append(p.getOffset());
            sb.append(VERBOSE_DELIMITER);
            sb.append(p.getRead().getLength());
            sb.append(VERBOSE_DELIMITER);
            sb.append(p.getRead().getMappingQuality());
        }
        return sb.toString();
    }
}

