/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.FastqQualityFormat;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.QualityEncodingDetector;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.FeatureCodec;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineParser;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.codecs.table.TableCodec;
import org.broadinstitute.hellbender.utils.codecs.table.TableFeature;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.spark.SparkUtils;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;
import scala.Tuple2;

@DocumentedFeature
@CommandLineProgramProperties(summary="This tool removes or restores certain properties of the SAM records, including alignment information, which can be used to produce an unmapped BAM (uBAM) from a previously aligned BAM. It is also capable of restoring the original quality scores of a BAM file that has already undergone base quality score recalibration (BQSR) if theoriginal qualities were retained.\n<h3>Examples</h3>\n<h4>Example with single output:</h4>\ngatk RevertSamSpark \\\n     -I input.bam \\\n     -O reverted.bam\n\n<h4>Example outputting by read group with output map:</h4>\ngatk RevertSamSpark \\\n     -I input.bam \\\n     --output-by-readgroup \\\n     --output-map reverted_bam_paths.tsv\n\nWill output a BAM/CRAM/SAM file per read group.\n<h4>Example outputting by read group without output map:</h4>\ngatk RevertSamSpark \\\n     -I input.bam \\\n     --output-by-readgroup \\\n     -O /write/reverted/read/group/bams/in/this/dir\n\nWill output a BAM file per read group. Output format can be overridden with the outputByReadgroupFileFormat option.\nNote: If the program fails due to a SAM validation error, consider setting the VALIDATION_STRINGENCY option to LENIENT or SILENT if the failures are expected to be obviated by the reversion process (e.g. invalid alignment information will be obviated when the keep-alignment-information option is used).\n", oneLineSummary="Reverts SAM, BAM or CRAM files to a previous state.", programGroup=ReadDataManipulationProgramGroup.class)
@BetaFeature
public class RevertSamSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    static final String USAGE_SUMMARY = "Reverts SAM, BAM or CRAM files to a previous state.";
    static final String USAGE_DETAILS = "This tool removes or restores certain properties of the SAM records, including alignment information, which can be used to produce an unmapped BAM (uBAM) from a previously aligned BAM. It is also capable of restoring the original quality scores of a BAM file that has already undergone base quality score recalibration (BQSR) if theoriginal qualities were retained.\n<h3>Examples</h3>\n<h4>Example with single output:</h4>\ngatk RevertSamSpark \\\n     -I input.bam \\\n     -O reverted.bam\n\n<h4>Example outputting by read group with output map:</h4>\ngatk RevertSamSpark \\\n     -I input.bam \\\n     --output-by-readgroup \\\n     --output-map reverted_bam_paths.tsv\n\nWill output a BAM/CRAM/SAM file per read group.\n<h4>Example outputting by read group without output map:</h4>\ngatk RevertSamSpark \\\n     -I input.bam \\\n     --output-by-readgroup \\\n     -O /write/reverted/read/group/bams/in/this/dir\n\nWill output a BAM file per read group. Output format can be overridden with the outputByReadgroupFileFormat option.\nNote: If the program fails due to a SAM validation error, consider setting the VALIDATION_STRINGENCY option to LENIENT or SILENT if the failures are expected to be obviated by the reversion process (e.g. invalid alignment information will be obviated when the keep-alignment-information option is used).\n";
    public static final String OUTPUT_MAP_READ_GROUP_FIELD_NAME = "READ_GROUP_ID";
    public static final String OUTPUT_MAP_OUTPUT_FILE_FIELD_NAME = "OUTPUT";
    @Argument(mutex={"output-map"}, shortName="O", fullName="output", doc="The output SAM/BAM/CRAM file to create, or an output directory if '--output-by-readgroup' is set.")
    public String output;
    public static final String OUTPUT_MAP_LONG_NAME = "output-map";
    @Argument(mutex={"output"}, fullName="output-map", doc="Tab separated file with two columns, OUTPUT_MAP_READ_GROUP_FIELD_NAME and OUTPUT_MAP_OUTPUT_FILE_FIELD_NAME, providing file mapping only used if '--output-by-readgroup' is set.")
    public String outputMap;
    public static final String OUTPUT_BY_READGROUP_LONG_NAME = "output-by-readgroup";
    @Argument(fullName="output-by-readgroup", doc="When true, outputs each read group in a separate file.")
    public boolean outputByReadGroup = false;
    @Argument(doc="WARNING: This option is potentially destructive. If enabled will discard reads in order to produce a consistent output BAM. Reads discarded include (but are not limited to) paired reads with missing mates, duplicated records, records with mismatches in length of bases and qualities. This option should only be enabled if the output sort order is queryname and will always cause sorting to occur.")
    public boolean sanitize = false;
    public static final String KEEP_FIRST_DUPLICATE_LONG_NAME = "keep-first-duplicate";
    @Argument(doc="If 'sanitize' only one record when we find more than one record with the same name for R1/R2/unpaired reads respectively. For paired end reads, keeps only the first R1 and R2 found respectively, and discards all unpaired reads. Duplicates do not refer to the duplicate flag in the FLAG field, but instead reads with the same name.", fullName="keep-first-duplicate")
    public boolean keepFirstDuplicate = false;
    public static final String OUTPUT_BY_READGROUP_FILE_FORMAT_LONG_NAME = "output-by-readgroup-file-format";
    @Argument(fullName="output-by-readgroup-file-format", doc="When using --output-by-readgroup, the output file format can be set to a certain format.")
    public FileType outputByReadgroupFileFormat = FileType.dynamic;
    @Argument(shortName="SO", fullName="sort-order", doc="The sort order to create the reverted output file with, defaults to whatever is specified in the current file", optional=true)
    public SAMFileHeader.SortOrder sortOrder = SAMFileHeader.SortOrder.queryname;
    public static final String DONT_RESTORE_ORIGINAL_QUALITIES_LONG_NAME = "dont-restore-original-qualities";
    @Argument(fullName="dont-restore-original-qualities", doc="Set to prevent the tool from setting the OQ field to the QUAL where available.", optional=true)
    public boolean dontRestoreOriginalQualities = false;
    public static final String DONT_REMOVE_DUPLICATE_INFORMATION_LONG_NAME = "remove-duplicate-information";
    @Argument(fullName="remove-duplicate-information", doc="By default we remove duplicate read flags from all reads.  Note that if this is true,  the output may have the unusual but sometimes desirable trait of having unmapped reads that are marked as duplicates.")
    public boolean keepDuplicateInformation = false;
    public static final String KEEP_ALIGNMENT_INFORMATION = "keep-alignment-information";
    @Argument(fullName="keep-alignment-information", doc="Don't remove any of the alignment information from the file.")
    public boolean keepAlignmentInformation = false;
    public static final String ATTRIBUTE_TO_CLEAR_LONG_NAME = "attributes-to-clear";
    @Argument(fullName="attributes-to-clear", doc="When removing alignment information, the set of optional tags to remove.", optional=true)
    public Set<String> attributesToClear = new HashSet<String>();
    public static final String REMOVE_DEFAULT_ATTRIBUTE_TO_CLEAR_LONG_NAME = "remove-default-attributes-to-clear";
    @Argument(fullName="remove-default-attributes-to-clear", doc="When removing alignment information, the set of optional tags to remove.", optional=true)
    public boolean removeDefaults = false;
    public static final String SAMPLE_ALIAS_ARG = "sample-alias";
    @Argument(fullName="sample-alias", doc="The sample alias to use in the reverted output file.  This will override the existing sample alias in the file and is used only if all the read groups in the input file have the same sample alias.", shortName="ALIAS", optional=true)
    public String sampleAlias;
    public static final String LIBRARY_NAME_ARG = "library-name";
    @Argument(fullName="library-name", doc="The library name to use in the reverted output file.  This will override the existing sample alias in the file and is used only if all the read groups in the input file have the same library name.", optional=true)
    public String libraryName;
    public static final List<String> DEFAULT_ATTRIBUTES_TO_CLEAR = Collections.unmodifiableList(new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(SAMTag.NM.name());
            this.add(SAMTag.UQ.name());
            this.add(SAMTag.PG.name());
            this.add(SAMTag.MD.name());
            this.add(SAMTag.MQ.name());
            this.add(SAMTag.SA.name());
            this.add(SAMTag.MC.name());
            this.add(SAMTag.AS.name());
        }
    });

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return Collections.singletonList(ReadFilterLibrary.ALLOW_ALL_READS);
    }

    @Override
    protected String[] customCommandLineValidation() {
        ArrayList<String> errors = new ArrayList<String>();
        RevertSamSpark.validateOutputParams(this.outputByReadGroup, this.output, this.outputMap);
        if (!this.sanitize && this.keepFirstDuplicate) {
            errors.add("'keepFirstDuplicate' cannot be used without 'sanitize'");
        }
        if (!errors.isEmpty()) {
            return errors.toArray(new String[errors.size()]);
        }
        return null;
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        Broadcast headerBroadcast = ctx.broadcast((Object)this.getHeaderForReads());
        JavaRDD<GATKRead> reads = this.getReads();
        SAMFileHeader localHeader = (SAMFileHeader)headerBroadcast.getValue();
        RevertSamSpark.validateHeaderOverrides(localHeader, this.sampleAlias, this.libraryName);
        if (this.sampleAlias != null) {
            localHeader.getReadGroups().forEach(rg -> rg.setSample(this.sampleAlias));
        }
        if (this.libraryName != null) {
            localHeader.getReadGroups().forEach(rg -> rg.setLibrary(this.libraryName));
        }
        Map<String, Path> writerMap = RevertSamSpark.getOutputMap(this.outputMap, this.output, RevertSamSpark.getDefaultExtension(this.readArguments.getReadPathSpecifiers().get(0), this.outputByReadgroupFileFormat), localHeader.getReadGroups(), this.outputByReadGroup);
        Map<String, SAMFileHeader> headerMap = this.getReadGroupHeaderMap(localHeader, writerMap);
        ArrayList<String> attributesToRevert = this.removeDefaults ? DEFAULT_ATTRIBUTES_TO_CLEAR : new ArrayList<String>();
        attributesToRevert.addAll(this.attributesToClear);
        JavaRDD readsReverted = this.revertReads(reads, attributesToRevert);
        if (this.sanitize) {
            Map<String, FastqQualityFormat> readGroupFormatMap = this.createReadGroupFormatMap(readsReverted, (Broadcast<SAMFileHeader>)headerBroadcast, !this.dontRestoreOriginalQualities);
            readsReverted = this.sanitize(readGroupFormatMap, readsReverted, localHeader, this.keepFirstDuplicate);
        }
        for (Map.Entry<String, Path> rmap : writerMap.entrySet()) {
            String key = rmap.getKey();
            JavaRDD filteredreads = rmap.getKey() == null ? readsReverted : readsReverted.filter((Function & Serializable)r -> r.getReadGroup().equals(key));
            this.writeReads(ctx, rmap.getValue().toString(), (JavaRDD<GATKRead>)filteredreads, headerMap.get(rmap.getKey()), false);
        }
    }

    private Map<String, FastqQualityFormat> createReadGroupFormatMap(JavaRDD<GATKRead> reads, final Broadcast<SAMFileHeader> inHeader, boolean restoreOriginalQualities) {
        HashMap<String, FastqQualityFormat> output = new HashMap<String, FastqQualityFormat>();
        ((SAMFileHeader)inHeader.getValue()).getReadGroups().stream().forEach(rg -> {
            String key = rg.getId();
            final JavaRDD filtered = reads.filter((Function & Serializable)r -> r.getReadGroup().equals(key));
            if (!filtered.isEmpty()) {
                CloseableIterator<SAMRecord> iterator = new CloseableIterator<SAMRecord>(){
                    Iterator delegateIterator;
                    {
                        this.delegateIterator = filtered.take(10000).iterator();
                    }

                    public void close() {
                        this.delegateIterator = null;
                    }

                    public boolean hasNext() {
                        return this.delegateIterator != null && this.delegateIterator.hasNext();
                    }

                    public SAMRecord next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException("hasNext should be called before next");
                        }
                        return ((GATKRead)this.delegateIterator.next()).convertToSAMRecord((SAMFileHeader)inHeader.getValue());
                    }
                };
                output.put(rg.getId(), QualityEncodingDetector.detect((long)10000L, (CloseableIterator)iterator, (boolean)restoreOriginalQualities));
            }
        });
        return output;
    }

    private JavaRDD<GATKRead> sanitize(Map<String, FastqQualityFormat> readGroupToFormat, JavaRDD<GATKRead> reads, SAMFileHeader header, boolean keepFirstDuplicate) {
        JavaRDD<GATKRead> sortedReads = SparkUtils.querynameSortReadsIfNecessary((JavaRDD<GATKRead>)reads.filter((Function & Serializable)r -> r.getLength() == r.getBaseQualityCount()), this.getRecommendedNumReducers(), header);
        JavaPairRDD<String, Iterable<GATKRead>> readsByGroup = RevertSamSpark.spanReadsByKey(sortedReads);
        return readsByGroup.flatMap((FlatMapFunction & Serializable)group -> {
            ArrayList out = Lists.newArrayList();
            List<Object> primaryReads = Utils.stream((Iterable)group._2()).collect(Collectors.toList());
            int firsts = 0;
            int seconds = 0;
            int unpaired = 0;
            GATKRead firstRecord = null;
            GATKRead secondRecord = null;
            GATKRead unpairedRecord = null;
            for (GATKRead rec : primaryReads) {
                if (!rec.isPaired()) {
                    if (unpairedRecord == null) {
                        unpairedRecord = rec;
                    }
                    ++unpaired;
                    continue;
                }
                if (rec.isFirstOfPair()) {
                    if (firstRecord == null) {
                        firstRecord = rec;
                    }
                    ++firsts;
                }
                if (!rec.isSecondOfPair()) continue;
                if (secondRecord == null) {
                    secondRecord = rec;
                }
                ++seconds;
            }
            if (firsts > 0 || seconds > 0) {
                if (firsts != 1 || seconds != 1) {
                    if (!keepFirstDuplicate || firsts < 1 || seconds < 1) return out.iterator();
                    primaryReads = Arrays.asList(firstRecord, secondRecord);
                }
            } else if (unpaired > 1) {
                if (!keepFirstDuplicate) return out.iterator();
                primaryReads = Collections.singletonList(unpairedRecord);
            }
            for (GATKRead rec : primaryReads) {
                FastqQualityFormat recordFormat = (FastqQualityFormat)readGroupToFormat.get(rec.getReadGroup());
                if (recordFormat != null && !recordFormat.equals((Object)FastqQualityFormat.Standard)) {
                    byte[] quals = rec.getBaseQualities();
                    int i = 0;
                    while (i < quals.length) {
                        int n = i++;
                        quals[n] = (byte)(quals[n] - 31);
                    }
                    rec.setBaseQualities(quals);
                }
                out.add(rec);
            }
            return out.iterator();
        });
    }

    private static JavaPairRDD<String, Iterable<GATKRead>> spanReadsByKey(JavaRDD<GATKRead> reads) {
        JavaPairRDD nameReadPairs = reads.mapToPair((PairFunction & Serializable)read -> new Tuple2((Object)read.getName(), read));
        return SparkUtils.spanByKey(nameReadPairs).flatMapToPair((PairFlatMapFunction & Serializable)namedRead -> {
            ArrayList out = Lists.newArrayList();
            LinkedListMultimap multi = LinkedListMultimap.create();
            for (GATKRead read : (Iterable)namedRead._2()) {
                multi.put((Object)read.getName(), (Object)read);
            }
            for (String key : multi.keySet()) {
                out.add(new Tuple2((Object)key, (Object)Lists.newArrayList((Iterable)multi.get((Object)key))));
            }
            return out.iterator();
        });
    }

    private Map<String, SAMFileHeader> getReadGroupHeaderMap(SAMFileHeader inHeader, Map<String, Path> writerMap) {
        Map<String, SAMFileHeader> headerMap;
        if (this.outputByReadGroup) {
            if (inHeader.getReadGroups().isEmpty()) {
                throw new UserException("The header is missing its read group map");
            }
            RevertSamSpark.assertAllReadGroupsMapped(writerMap, inHeader.getReadGroups());
            headerMap = new HashMap<String, SAMFileHeader>();
            for (SAMReadGroupRecord readGroup : inHeader.getReadGroups()) {
                SAMFileHeader header = RevertSamSpark.createOutHeader(inHeader, this.sortOrder, !this.keepAlignmentInformation);
                header.addReadGroup(readGroup);
                headerMap.put(readGroup.getId(), header);
            }
        } else {
            SAMFileHeader singleOutHeader = RevertSamSpark.createOutHeader(inHeader, this.sortOrder, !this.keepAlignmentInformation);
            inHeader.getReadGroups().forEach(arg_0 -> ((SAMFileHeader)singleOutHeader).addReadGroup(arg_0));
            headerMap = Collections.singletonMap(null, singleOutHeader);
        }
        return headerMap;
    }

    private static SAMFileHeader createOutHeader(SAMFileHeader inHeader, SAMFileHeader.SortOrder sortOrder, boolean removeAlignmentInformation) {
        SAMFileHeader outHeader = new SAMFileHeader();
        outHeader.setSortOrder(sortOrder);
        if (!removeAlignmentInformation) {
            outHeader.setSequenceDictionary(inHeader.getSequenceDictionary());
            outHeader.setProgramRecords(inHeader.getProgramRecords());
        }
        return outHeader;
    }

    @VisibleForTesting
    static String getDefaultExtension(GATKPath inputPath, FileType setting) {
        if (setting == FileType.dynamic) {
            if (inputPath.isSam()) {
                return ".sam";
            }
            if (inputPath.isCram()) {
                return ".cram";
            }
            return ".bam";
        }
        return "." + setting.toString();
    }

    public JavaRDD<GATKRead> revertReads(JavaRDD<GATKRead> reads, List<String> attributesToClear) {
        Broadcast attrBroadcast = JavaSparkContext.fromSparkContext((SparkContext)reads.context()).broadcast(attributesToClear);
        if (!this.dontRestoreOriginalQualities) {
            reads = reads.map((Function & Serializable)r -> {
                byte[] oq = ReadUtils.getOriginalBaseQualities(r);
                if (oq != null) {
                    r.setBaseQualities(oq);
                    r.setAttribute("OQ", (String)null);
                }
                return r;
            });
        }
        if (!this.keepDuplicateInformation) {
            reads = reads.map((Function & Serializable)r -> {
                r.setIsDuplicate(false);
                return r;
            });
        }
        if (!this.keepAlignmentInformation) {
            reads = reads.map((Function & Serializable)rec -> {
                if (rec.isReverseStrand()) {
                    rec.reverseComplement();
                    rec.setIsReverseStrand(false);
                }
                rec.setIsUnplaced();
                rec.setCigar("*");
                rec.setFragmentLength(0);
                rec.setIsSecondaryAlignment(false);
                rec.setIsProperlyPaired(false);
                rec.setMateIsUnplaced();
                ((List)attrBroadcast.getValue()).forEach(tag -> rec.setAttribute((String)tag, (String)null));
                return rec;
            });
        }
        return reads;
    }

    @VisibleForTesting
    static Map<String, Path> getOutputMap(String outputMapFile, String outputDir, String defaultExtension, List<SAMReadGroupRecord> readGroups, boolean outputByReadgroup) {
        if (outputByReadgroup) {
            Map<String, Path> outputMap;
            if (outputMapFile != null) {
                try {
                    outputMap = RevertSamSpark.createOutputMapFromFile(outputMapFile);
                }
                catch (IOException e) {
                    throw new UserException("Encountered an error reading output map file", e);
                }
            } else {
                outputMap = RevertSamSpark.createOutputMapFromHeader(readGroups, outputDir, defaultExtension);
            }
            return outputMap;
        }
        return Collections.singletonMap(null, IOUtils.getPath(outputDir));
    }

    private static Map<String, Path> createOutputMapFromFile(String outputMapFile) throws IOException {
        HashMap<String, Path> outputMap = new HashMap<String, Path>();
        try (AbstractFeatureReader parser = AbstractFeatureReader.getFeatureReader((String)outputMapFile, (FeatureCodec)new TableCodec(null), (boolean)false);){
            for (TableFeature row : parser.iterator()) {
                String id = row.get(OUTPUT_MAP_READ_GROUP_FIELD_NAME);
                String output = row.get(OUTPUT_MAP_OUTPUT_FILE_FIELD_NAME);
                Path outputPath = IOUtils.getPath(output);
                outputMap.put(id, outputPath);
            }
        }
        return outputMap;
    }

    private static Map<String, Path> createOutputMapFromHeader(List<SAMReadGroupRecord> readGroups, String outputDir, String extension) {
        HashMap<String, Path> outputMap = new HashMap<String, Path>();
        for (SAMReadGroupRecord readGroup : readGroups) {
            String id = readGroup.getId();
            String fileName = id + extension;
            Path outputPath = Paths.get(outputDir, fileName);
            outputMap.put(id, outputPath);
        }
        return outputMap;
    }

    static List<String> validateOutputParams(boolean outputByReadGroup, String output, String outputMap) {
        ArrayList<String> errors = new ArrayList<String>();
        try {
            if (outputByReadGroup) {
                errors.addAll(RevertSamSpark.validateOutputParamsByReadGroup(output, outputMap));
            } else {
                errors.addAll(RevertSamSpark.validateOutputParamsNotByReadGroup(output, outputMap));
            }
        }
        catch (IOException e) {
            throw new UserException.BadInput("Error while validating input file", e);
        }
        return errors;
    }

    static List<String> validateOutputParamsByReadGroup(String output, String outputMap) throws IOException {
        ArrayList<String> errors = new ArrayList<String>();
        if (output != null) {
            if (!Files.isDirectory(IOUtil.getPath((String)output), new LinkOption[0])) {
                errors.add("When '--output-by-readgroup' is set and output is provided, it must be a directory: " + output);
            }
            return errors;
        }
        if (outputMap == null) {
            errors.add("Must provide either output or outputMap when '--output-by-readgroup' is set.");
            return errors;
        }
        if (!Files.isReadable(IOUtil.getPath((String)outputMap))) {
            errors.add("Cannot read outputMap " + outputMap);
            return errors;
        }
        AbstractFeatureReader parser = AbstractFeatureReader.getFeatureReader((String)outputMap, (FeatureCodec)new TableCodec(null), (boolean)false);
        if (!RevertSamSpark.isOutputMapHeaderValid((List)parser.getHeader())) {
            errors.add("Invalid header: " + outputMap + ". Must be a tab-separated file with +" + OUTPUT_MAP_READ_GROUP_FIELD_NAME + "+ as first column and output as second column.");
        }
        return errors;
    }

    static List<String> validateOutputParamsNotByReadGroup(String output, String outputMap) throws IOException {
        ArrayList<String> errors = new ArrayList<String>();
        if (outputMap != null) {
            errors.add("Cannot provide outputMap when '--output-by-read' isn't set. Provide output instead.");
        }
        if (output == null) {
            errors.add("output is required when '--output-by-read'");
            return errors;
        }
        if (Files.isDirectory(IOUtil.getPath((String)output), new LinkOption[0])) {
            errors.add("output " + output + " should not be a directory when '--output-by-read'");
        }
        return errors;
    }

    static void validateHeaderOverrides(SAMFileHeader inHeader, String sampleAlias, String libraryName) {
        List rgs = inHeader.getReadGroups();
        if (sampleAlias != null || libraryName != null) {
            boolean allSampleAliasesIdentical = true;
            boolean allLibraryNamesIdentical = true;
            for (int i = 1; i < rgs.size(); ++i) {
                if (!((SAMReadGroupRecord)rgs.get(0)).getSample().equals(((SAMReadGroupRecord)rgs.get(i)).getSample())) {
                    allSampleAliasesIdentical = false;
                }
                if (((SAMReadGroupRecord)rgs.get(0)).getLibrary().equals(((SAMReadGroupRecord)rgs.get(i)).getLibrary())) continue;
                allLibraryNamesIdentical = false;
            }
            if (sampleAlias != null && !allSampleAliasesIdentical) {
                throw new UserException("Read groups have multiple values for sample.  A value for sampleAlias cannot be supplied.");
            }
            if (libraryName != null && !allLibraryNamesIdentical) {
                throw new UserException("Read groups have multiple values for library name.  A value for library name cannot be supplied.");
            }
        }
    }

    static void assertAllReadGroupsMapped(Map<String, Path> outputMap, List<SAMReadGroupRecord> readGroups) {
        for (SAMReadGroupRecord readGroup : readGroups) {
            String id = readGroup.getId();
            Path output = outputMap.get(id);
            if (output != null) continue;
            throw new GATKException("Read group id " + id + " not found in outputMap " + outputMap);
        }
    }

    static boolean isOutputMapHeaderValid(List<String> columnLabels) {
        return columnLabels.size() >= 2 && OUTPUT_MAP_READ_GROUP_FIELD_NAME.equals(columnLabels.get(0)) && OUTPUT_MAP_OUTPUT_FILE_FIELD_NAME.equals(columnLabels.get(1));
    }

    public static enum FileType implements CommandLineParser.ClpEnum
    {
        sam("Generate SAM files."),
        bam("Generate BAM files."),
        cram("Generate CRAM files."),
        dynamic("Generate files based on the extension of input.");

        final String description;

        private FileType(String description) {
            this.description = description;
        }

        public String getHelpDoc() {
            return this.description;
        }
    }
}

