/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.bwa;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.argumentcollections.SequenceDictionaryValidationArgumentCollection;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.engine.spark.datasources.ReadsSparkSink;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.bwa.BwaArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.bwa.BwaSparkEngine;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadsWriteFormat;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@DocumentedFeature
@CommandLineProgramProperties(summary="Align reads using BWA", oneLineSummary="Align reads to a given reference using BWA on Spark", programGroup=ReadDataManipulationProgramGroup.class)
@BetaFeature
public final class BwaSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    @Argument(doc="the output bam", shortName="O", fullName="output")
    private String output;
    @ArgumentCollection
    public final BwaArgumentCollection bwaArgs = new BwaArgumentCollection();

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return Arrays.asList(ReadFilterLibrary.PRIMARY_LINE, ReadFilterLibrary.SEQ_IS_STORED);
    }

    @Override
    public SequenceDictionaryValidationArgumentCollection getSequenceDictionaryValidationArgumentCollection() {
        return new SequenceDictionaryValidationArgumentCollection.NoValidationCollection();
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        try (BwaSparkEngine bwaEngine = new BwaSparkEngine(ctx, this.referenceArguments.getReferenceFileName(), this.bwaArgs.indexImageFile, this.getHeaderForReads(), this.getReferenceSequenceDictionary());){
            JavaRDD reads;
            if (this.bwaArgs.singleEndAlignment) {
                reads = bwaEngine.alignUnpaired(this.getReads());
            } else {
                ReadFilter filter = this.makeReadFilter(bwaEngine.getHeader());
                reads = bwaEngine.alignPaired(this.getUnfilteredReads()).filter(filter::test);
            }
            try {
                ReadsSparkSink.writeReads(ctx, this.output, null, (JavaRDD<GATKRead>)reads, bwaEngine.getHeader(), this.shardedOutput ? ReadsWriteFormat.SHARDED : ReadsWriteFormat.SINGLE, this.getRecommendedNumReducers(), this.shardedPartsDir, this.shardedOutput, this.splittingIndexGranularity);
            }
            catch (IOException e) {
                throw new GATKException("Unable to write aligned reads", e);
            }
        }
    }
}

