/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSKmerCollection;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSKmerUtils;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmer;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmerShort;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmerizer;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class ContainsKmerReadFilter
extends ReadFilter {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    private static volatile PSKmerCollection kmerLib = null;
    private final int kSize;
    private final int kmerCountThreshold;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ContainsKmerReadFilter(String kmerLibPath, int kmerCountThreshold) {
        this.kmerCountThreshold = kmerCountThreshold;
        if (kmerLib == null) {
            Class<ContainsKmerReadFilter> clazz = ContainsKmerReadFilter.class;
            // MONITORENTER : org.broadinstitute.hellbender.tools.spark.pathseq.ContainsKmerReadFilter.class
            if (kmerLib == null) {
                kmerLib = PSKmerUtils.readKmerFilter(kmerLibPath);
                this.logger.info("Loaded static kmer filter with false positive probability " + kmerLib.getFalsePositiveProbability());
            }
            // MONITOREXIT : clazz
        }
        this.kSize = kmerLib.kmerSize();
    }

    @Override
    public boolean test(GATKRead read) {
        SVKmerizer kmers = new SVKmerizer(read.getBases(), this.kSize, 1, (SVKmer)new SVKmerShort(this.kSize));
        int numKmersFound = 0;
        while (kmers.hasNext()) {
            if (!kmerLib.contains((SVKmerShort)kmers.next()) || ++numKmersFound < this.kmerCountThreshold) continue;
            return false;
        }
        return true;
    }

    public static void closeKmerLib() {
        kmerLib = null;
    }
}

