/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.VoidFunction;
import org.broadinstitute.hellbender.tools.spark.pathseq.ContainsKmerReadFilter;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class ContainsKmerReadFilterSpark
implements Function<GATKRead, Boolean> {
    private static final long serialVersionUID = 1L;
    private final String kmerSetPath;
    private final int kmerCountThreshold;
    private transient ContainsKmerReadFilter filter;

    public ContainsKmerReadFilterSpark(String kmerSetPath, int kmerCountThreshold) {
        this.kmerSetPath = kmerSetPath;
        this.kmerCountThreshold = kmerCountThreshold;
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.filter = new ContainsKmerReadFilter(this.kmerSetPath, this.kmerCountThreshold);
    }

    public Boolean call(GATKRead read) {
        if (this.filter == null) {
            this.filter = new ContainsKmerReadFilter(this.kmerSetPath, this.kmerCountThreshold);
        }
        return this.filter.test(read);
    }

    public static void closeAllDistributedInstances(JavaSparkContext ctx) {
        int nJobs = ctx.defaultParallelism();
        ArrayList<Integer> jobList = new ArrayList<Integer>(nJobs);
        for (int idx2 = 0; idx2 != nJobs; ++idx2) {
            jobList.add(idx2);
        }
        ctx.parallelize(jobList, nJobs).foreach((VoidFunction & Serializable)idx -> ContainsKmerReadFilter.closeKmerLib());
    }
}

