/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import htsjdk.samtools.Cigar;
import java.util.Collections;
import java.util.Set;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class HostAlignmentReadFilter
extends ReadFilter {
    private static final long serialVersionUID = 1L;
    private final int minIdentity;
    private final Set<String> excludedContigs;

    public HostAlignmentReadFilter(int minIdent, Set<String> excludedContigs) {
        this.minIdentity = minIdent;
        this.excludedContigs = excludedContigs;
    }

    public HostAlignmentReadFilter(int minIdent) {
        this.minIdentity = minIdent;
        this.excludedContigs = Collections.emptySet();
    }

    @Override
    public boolean test(GATKRead read) {
        if (read.isUnmapped()) {
            return true;
        }
        if (this.excludedContigs.contains(read.getContig())) {
            return true;
        }
        Integer nmVal = read.getAttributeAsInteger("NM");
        if (nmVal == null) {
            return true;
        }
        return this.test(read.getCigar(), nmVal);
    }

    public boolean test(Cigar cigar, int numMismatches) {
        return PSUtils.getMatchesLessDeletions(cigar, numMismatches) < this.minIdentity;
    }
}

