/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFlag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSBwaArgumentCollection;
import org.broadinstitute.hellbender.utils.bwa.BwaMemAligner;
import org.broadinstitute.hellbender.utils.bwa.BwaMemAlignment;
import org.broadinstitute.hellbender.utils.bwa.BwaMemAlignmentUtils;
import org.broadinstitute.hellbender.utils.bwa.BwaMemIndex;
import org.broadinstitute.hellbender.utils.bwa.BwaMemIndexCache;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.SAMRecordToGATKReadAdapter;

public final class PSBwaAligner {
    private final BwaMemIndex bwaIndex;
    private final PSBwaArgumentCollection bwaArgs;
    private final boolean pairedAlignment;

    public PSBwaAligner(PSBwaArgumentCollection bwaArgs, boolean pairedAlignment) {
        this.bwaIndex = BwaMemIndexCache.getInstance(bwaArgs.bwaImage);
        this.bwaArgs = bwaArgs;
        this.pairedAlignment = pairedAlignment;
    }

    private static GATKRead applyAlignments(GATKRead read, List<BwaMemAlignment> alignmentList, List<String> refNames, SAMFileHeader header) {
        ArrayList<String> saTags = new ArrayList<String>(alignmentList.size());
        for (BwaMemAlignment alignment : alignmentList) {
            if (!SAMFlag.SECONDARY_ALIGNMENT.isUnset(alignment.getSamFlag()) || !SAMFlag.SUPPLEMENTARY_ALIGNMENT.isUnset(alignment.getSamFlag())) continue;
            if (read.isUnmapped()) {
                read = new SAMRecordToGATKReadAdapter(BwaMemAlignmentUtils.applyAlignment(read.getName(), read.getBases(), read.getBaseQualities(), read.getReadGroup(), alignment, refNames, header, false, false));
                continue;
            }
            if (alignment.getRefId() == -1) continue;
            saTags.add(BwaMemAlignmentUtils.asTag(alignment, refNames));
        }
        if (!saTags.isEmpty()) {
            String currentTag = read.getAttributeAsString("SA") != null ? read.getAttributeAsString("SA") : "";
            read.setAttribute("SA", currentTag + String.join((CharSequence)";", saTags));
        }
        return read;
    }

    public Iterator<GATKRead> apply(Iterator<GATKRead> itr, SAMFileHeader header) {
        BwaMemAligner aligner = new BwaMemAligner(this.bwaIndex);
        if (this.pairedAlignment) {
            aligner.alignPairs();
        }
        aligner.setMaxXAHitsAltOption(this.bwaArgs.maxAlternateHits);
        aligner.setMaxXAHitsOption(this.bwaArgs.maxAlternateHits);
        aligner.setMinSeedLengthOption(this.bwaArgs.seedLength);
        aligner.setOutputScoreThresholdOption(this.bwaArgs.scoreThreshold);
        aligner.setNThreadsOption(this.bwaArgs.bwaThreads);
        ArrayList<GATKRead> reads = new ArrayList<GATKRead>();
        while (itr.hasNext()) {
            reads.add(itr.next());
        }
        int numReads = reads.size();
        if (this.pairedAlignment && numReads % 2 != 0) {
            throw new UserException.BadInput("Expected paired reads but there are an odd number");
        }
        if (numReads == 0) {
            return new ArrayList(0).iterator();
        }
        List refNames = this.bwaIndex.getReferenceContigNames();
        List alignments = aligner.alignSeqs(reads, GATKRead::getBases);
        for (int i = 0; i < reads.size(); ++i) {
            reads.set(i, PSBwaAligner.applyAlignments((GATKRead)reads.get(i), (List)alignments.get(i), refNames, header));
        }
        return reads.iterator();
    }
}

