/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import htsjdk.samtools.SAMFileHeader;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSBwaAligner;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSBwaArgumentCollection;
import org.broadinstitute.hellbender.utils.bwa.BwaMemIndexCache;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class PSBwaAlignerSpark
implements AutoCloseable {
    final PSBwaArgumentCollection bwaArgs;
    private final JavaSparkContext ctx;

    public PSBwaAlignerSpark(JavaSparkContext ctx, PSBwaArgumentCollection bwaArgs) {
        this.ctx = ctx;
        this.bwaArgs = bwaArgs;
    }

    public JavaRDD<GATKRead> doBwaAlignment(JavaRDD<GATKRead> reads, boolean pairedAlignment, Broadcast<SAMFileHeader> header) {
        PSBwaArgumentCollection bwaArgsLocal = this.bwaArgs;
        return reads.mapPartitions((FlatMapFunction & Serializable)itr -> new PSBwaAligner(bwaArgsLocal, pairedAlignment).apply((Iterator<GATKRead>)itr, (SAMFileHeader)header.value()));
    }

    @Override
    public void close() {
        BwaMemIndexCache.closeAllDistributedInstances(this.ctx);
    }
}

