/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import htsjdk.samtools.TextCigarCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.pathseq.HostAlignmentReadFilter;
import org.broadinstitute.hellbender.utils.bwa.BwaMemAligner;
import org.broadinstitute.hellbender.utils.bwa.BwaMemAlignment;
import org.broadinstitute.hellbender.utils.bwa.BwaMemIndex;
import org.broadinstitute.hellbender.utils.bwa.BwaMemIndexCache;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class PSBwaFilter {
    private final BwaMemIndex bwaIndex;
    private final int minIdent;
    private final int minSeedLength;
    private final int numThreads;
    private final boolean bPaired;

    public PSBwaFilter(String indexFileName, int minIdent, int minSeedLength, int numThreads, boolean bPaired) {
        this.bwaIndex = BwaMemIndexCache.getInstance(indexFileName);
        this.minIdent = minIdent;
        this.minSeedLength = minSeedLength;
        this.numThreads = numThreads;
        this.bPaired = bPaired;
    }

    public Iterator<GATKRead> apply(Iterator<GATKRead> itr) {
        BwaMemAligner aligner = new BwaMemAligner(this.bwaIndex);
        if (this.bPaired) {
            aligner.alignPairs();
        }
        aligner.setMaxXAHitsAltOption(0);
        aligner.setMaxXAHitsOption(0);
        aligner.setMinSeedLengthOption(this.minSeedLength);
        aligner.setOutputScoreThresholdOption(0);
        aligner.setNThreadsOption(this.numThreads);
        ArrayList<GATKRead> reads = new ArrayList<GATKRead>();
        while (itr.hasNext()) {
            reads.add(itr.next());
        }
        int numReads = reads.size();
        if (this.bPaired && (numReads & 1) != 0) {
            throw new GATKException("Cannot do paired alignment with an odd number of reads");
        }
        if (numReads == 0) {
            return Collections.emptyIterator();
        }
        List alignments = aligner.alignSeqs(reads, GATKRead::getBases);
        HostAlignmentReadFilter hostFilter = new HostAlignmentReadFilter(this.minIdent);
        ArrayList results = new ArrayList(numReads);
        for (int i = 0; i < numReads; ++i) {
            if (!PSBwaFilter.testReadAlignments(hostFilter, (List)alignments.get(i))) continue;
            results.add(reads.get(i));
        }
        results.trimToSize();
        return results.iterator();
    }

    private static boolean testReadAlignments(HostAlignmentReadFilter hostFilter, List<BwaMemAlignment> alignmentList) {
        for (BwaMemAlignment alignment : alignmentList) {
            if (alignment.getCigar() == null || alignment.getCigar().isEmpty() || hostFilter.test(TextCigarCodec.decode((String)alignment.getCigar()), alignment.getNMismatches())) continue;
            return false;
        }
        return true;
    }
}

