/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.reference.ReferenceUtils;

public final class PSBwaUtils {
    static void addReferenceSequencesToHeader(SAMFileHeader header, String referenceDictionaryPath) {
        List<SAMSequenceRecord> refSeqs = PSBwaUtils.getReferenceSequences(referenceDictionaryPath);
        for (SAMSequenceRecord rec : refSeqs) {
            if (header.getSequence(rec.getSequenceName()) != null) continue;
            header.addSequence(rec);
        }
    }

    private static List<SAMSequenceRecord> getReferenceSequences(String referenceDictionaryPath) {
        SAMSequenceDictionary referenceDictionary = ReferenceUtils.loadFastaDictionary(new File(referenceDictionaryPath));
        return referenceDictionary.getSequences();
    }

    static SAMFileHeader removeUnmappedHeaderSequences(SAMFileHeader header, JavaRDD<GATKRead> reads, Logger logger) {
        List<String> usedSequences = PSBwaUtils.getAlignedSequenceNames(reads);
        List usedSequenceRecords = usedSequences.stream().map(seqName -> header.getSequence(seqName)).filter(seq -> {
            if (seq != null) {
                return true;
            }
            logger.warn("One or more reads are aligned to sequence " + seq + " but it is not in the header");
            return false;
        }).collect(Collectors.toList());
        header.setSequenceDictionary(new SAMSequenceDictionary(usedSequenceRecords));
        return header;
    }

    static List<String> getAlignedSequenceNames(JavaRDD<GATKRead> reads) {
        return reads.flatMap(PSBwaUtils::getSequenceNames).distinct().collect();
    }

    private static Iterator<String> getSequenceNames(GATKRead read) {
        if (read.isUnmapped() || read.getAssignedContig().equals("*")) {
            return Collections.emptyIterator();
        }
        if (!read.hasAttribute("SA")) {
            return Collections.singleton(read.getAssignedContig()).iterator();
        }
        String[] saTokens = read.getAttributeAsString("SA").split(";");
        HashSet<String> sequenceNames = new HashSet<String>(SVUtils.hashMapCapacity(1 + saTokens.length));
        sequenceNames.add(read.getAssignedContig());
        for (String token : saTokens) {
            String[] alignmentTokens = token.split(",", 1);
            sequenceNames.add(alignmentTokens[0]);
        }
        return sequenceNames.iterator();
    }
}

