/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.hellbender.cmdline.GATKPlugin.GATKReadFilterPluginDescriptor;
import org.broadinstitute.hellbender.engine.filters.AmbiguousBaseReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadLengthReadFilter;

public final class PSFilterArgumentCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final int bwaThreads = 1;
    public static final String KMER_FILE_PATH_LONG_NAME = "kmer-file";
    public static final String FILTER_METRICS_FILE_LONG_NAME = "filter-metrics";
    public static final String FILTER_BWA_IMAGE_LONG_NAME = "filter-bwa-image";
    public static final String IS_HOST_ALIGNED_LONG_NAME = "is-host-aligned";
    public static final String SKIP_FILTERS_LONG_NAME = "skip-quality-filters";
    public static final String SKIP_PRE_BWA_REPARTITION_LONG_NAME = "skip-pre-bwa-repartition";
    public static final String MIN_CLIPPED_READ_LENGTH_LONG_NAME = "min-clipped-read-length";
    public static final String MAX_MASKED_BASES_LONG_NAME = "max-masked-bases";
    public static final String MIN_BASE_QUALITY_LONG_NAME = "min-base-quality";
    public static final String QUALITY_SCORE_THRESHOLD_LONG_NAME = "quality-threshold";
    public static final String DUST_MASK_QUALITY_LONG_NAME = "dust-mask-quality";
    public static final String DUST_WINDOW_SIZE_LONG_NAME = "dust-window";
    public static final String DUST_T_SCORE_LONG_NAME = "dust-t";
    public static final String HOST_MIN_IDENTITY_LONG_NAME = "host-min-identity";
    public static final String HOST_MIN_IDENTITY_SHORT_NAME = "host-min-identity";
    public static final String IGNORE_ALIGNMENT_CONTIGS_LONG_NAME = "ignore-alignment-contigs";
    public static final String IGNORE_ALIGNMENT_CONTIGS_SHORT_NAME = "ignore-alignment-contigs";
    public static final String HOST_KMER_COUNT_THRESHOLD_LONG_NAME = "host-kmer-thresh";
    public static final String FILTER_BWA_SEED_LENGTH_LONG_NAME = "filter-bwa-seed-length";
    public static final String FILTER_READS_PER_PARTITION_LONG_NAME = "filter-reads-per-partition";
    public static final String FILTER_DUPLICATES_LONG_NAME = "filter-duplicates";
    public static final String MAX_ADAPTER_MISMATCHES_LONG_NAME = "max-adapter-mismatches";
    public static final String MIN_ADAPTER_LENGTH_LONG_NAME = "min-adapter-length";
    @Argument(doc="Set if the input BAM is aligned to the host", fullName="is-host-aligned", optional=true)
    public boolean alignedInput = false;
    @Argument(doc="Path to host k-mer file generated with PathSeqBuildKmers. K-mer filtering is skipped if this is not specified.", fullName="kmer-file", optional=true)
    public String kmerFilePath = null;
    @Argument(doc="Skip low-quality and low-complexity read filtering", fullName="skip-quality-filters", optional=true)
    public boolean skipFilters = false;
    @Advanced
    @Argument(doc="Skip pre-BWA repartition. Set to true for inputs with a high proportion of microbial reads that are not host coordinate-sorted.", fullName="skip-pre-bwa-repartition", optional=true)
    public boolean skipPreBwaRepartition = false;
    @Argument(doc="Minimum length of reads after quality trimming", fullName="min-clipped-read-length", minValue=1.0, minRecommendedValue=31.0, optional=true)
    public int minReadLength = 31;
    @Argument(doc="Max allowable number of masked bases per read", fullName="max-masked-bases", minValue=0.0, optional=true)
    public int maxAmbiguousBases = 2;
    @Argument(doc="Bases below this call quality will be masked with 'N'", fullName="min-base-quality", minValue=1.0, optional=true)
    public int qualPhredThresh = 15;
    @Argument(doc="Quality score trimmer threshold", fullName="quality-threshold", minValue=1.0, optional=true)
    public int readTrimThresh = 15;
    @Argument(doc="Base quality to assign low-complexity bases", fullName="dust-mask-quality", optional=true)
    public int dustMask = 2;
    @Argument(doc="DUST algorithm window size", fullName="dust-window", optional=true)
    public int dustW = 64;
    @Argument(doc="DUST algorithm score threshold", fullName="dust-t", optional=true)
    public double dustT = 20.0;
    @Argument(doc="Host alignment identity score threshold, in bp", fullName="host-min-identity", minValue=1.0, optional=true)
    public int minIdentity = 30;
    @Argument(doc="Host-aligned BAM contigs to ignore", fullName="ignore-alignment-contigs", shortName="ignore-alignment-contigs", optional=true)
    public List<String> alignmentContigsToIgnore = new ArrayList<String>();
    @Argument(doc="Host kmer count threshold.", fullName="host-kmer-thresh", minValue=1.0, optional=true)
    public int hostKmerThresh = 1;
    @Argument(doc="The BWA image file of the host reference. This must be distributed to local disk on each node.", fullName="filter-bwa-image", optional=true)
    public String indexImageFile = null;
    @Argument(doc="Minimum seed length for the host BWA alignment.", fullName="filter-bwa-seed-length", minValue=1.0, minRecommendedValue=11.0, optional=true)
    public int minSeedLength = 19;
    @Advanced
    @Argument(doc="Estimated reads per partition after quality, kmer, and BWA filtering", fullName="filter-reads-per-partition", minValue=1.0, optional=true)
    public int filterReadsPerPartition = 200000;
    @Argument(doc="Filter duplicate reads", fullName="filter-duplicates", optional=true)
    public boolean filterDuplicates = true;
    @Argument(doc="Minimum length of adapter sequence to trim", fullName="min-adapter-length", minValue=1.0, optional=true)
    public int minAdapterLength = 12;
    @Argument(doc="Maximum number of mismatches for adapter trimming", fullName="max-adapter-mismatches", minValue=0.0, optional=true)
    public int maxAdapterMismatches = 1;
    @Argument(doc="Log counts of filtered reads to this file", fullName="filter-metrics", optional=true)
    public String filterMetricsFileUri = null;

    public void doReadFilterArgumentWarnings(GATKReadFilterPluginDescriptor pluginDescriptor, Logger logger) {
        List<ReadFilter> readFilters = pluginDescriptor.getResolvedInstances();
        for (ReadFilter filter : readFilters) {
            if (filter.getClass().isAssignableFrom(AmbiguousBaseReadFilter.class)) {
                logger.warn("Detected the use of AmbiguousBaseReadFilter, which is applied before the PathSeq base masking steps. Did you mean to use --max-masked-bases, which is applied after masking?");
                continue;
            }
            if (!filter.getClass().isAssignableFrom(ReadLengthReadFilter.class)) continue;
            logger.warn("Detected the use of ReadLengthReadFilter, which is applied before the PathSeq clipping steps. Did you mean to use --min-clipped-read-length, which is applied after clipping?");
        }
    }
}

