/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSKmerCollection;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmerShort;
import org.broadinstitute.hellbender.tools.spark.utils.LongBloomFilter;
import org.broadinstitute.hellbender.utils.Utils;

@DefaultSerializer(value=Serializer.class)
public final class PSKmerBloomFilter
extends PSKmerCollection {
    private final LongBloomFilter kmerSet;
    private final int kmerSize;
    private final SVKmerShort kmerMask;
    private final double falsePositiveProbability;

    public PSKmerBloomFilter(LongBloomFilter maskedKmerBloomFilter, int kmerSize, SVKmerShort kmerMask, long numElements) {
        Utils.nonNull(maskedKmerBloomFilter);
        Utils.nonNull(kmerMask);
        this.kmerSet = maskedKmerBloomFilter;
        this.kmerSize = kmerSize;
        this.kmerMask = kmerMask;
        this.falsePositiveProbability = this.kmerSet.getTheoreticalFPP(numElements);
    }

    private PSKmerBloomFilter(Kryo kryo, Input input) {
        this.kmerSize = input.readInt();
        this.kmerMask = new SVKmerShort(input.readLong());
        this.kmerSet = (LongBloomFilter)kryo.readObject(input, LongBloomFilter.class);
        this.falsePositiveProbability = input.readDouble();
    }

    @Override
    public boolean contains(SVKmerShort rawKmer) {
        return this.kmerSet.contains(PSKmerBloomFilter.canonicalizeAndMask(rawKmer, this.kmerSize, this.kmerMask));
    }

    @Override
    public int kmerSize() {
        return this.kmerSize;
    }

    @Override
    public SVKmerShort getMask() {
        return this.kmerMask;
    }

    @Override
    public double getFalsePositiveProbability() {
        return this.falsePositiveProbability;
    }

    private void serialize(Kryo kryo, Output output) {
        output.writeInt(this.kmerSize);
        output.writeLong(this.kmerMask.getLong());
        kryo.writeObject(output, (Object)this.kmerSet);
        output.writeDouble(this.falsePositiveProbability);
        output.close();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PSKmerBloomFilter)) {
            return false;
        }
        PSKmerBloomFilter psKmerSet = (PSKmerBloomFilter)o;
        if (this.kmerSize != psKmerSet.kmerSize) {
            return false;
        }
        if (!this.kmerSet.equals(psKmerSet.kmerSet)) {
            return false;
        }
        return this.kmerMask.equals(psKmerSet.kmerMask);
    }

    public int hashCode() {
        int result = this.kmerSet.hashCode();
        result = 31 * result + this.kmerSize;
        result = 31 * result + this.kmerMask.hashCode();
        return result;
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<PSKmerBloomFilter> {
        public void write(Kryo kryo, Output output, PSKmerBloomFilter kmerSet) {
            kmerSet.serialize(kryo, output);
        }

        public PSKmerBloomFilter read(Kryo kryo, Input input, Class<PSKmerBloomFilter> klass) {
            return new PSKmerBloomFilter(kryo, input);
        }
    }
}

