/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSKmerCollection;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmerShort;
import org.broadinstitute.hellbender.tools.spark.utils.LargeLongHopscotchSet;
import org.broadinstitute.hellbender.tools.spark.utils.LongIterator;
import org.broadinstitute.hellbender.utils.Utils;

@DefaultSerializer(value=Serializer.class)
public final class PSKmerSet
extends PSKmerCollection {
    private final LargeLongHopscotchSet kmerSet;
    private final int kmerSize;
    private final SVKmerShort kmerMask;

    public PSKmerSet(LargeLongHopscotchSet maskedKmerSet, int kmerSize, SVKmerShort kmerMask) {
        Utils.nonNull(maskedKmerSet);
        Utils.nonNull(kmerMask);
        this.kmerSet = maskedKmerSet;
        this.kmerSize = kmerSize;
        this.kmerMask = kmerMask;
    }

    private PSKmerSet(Kryo kryo, Input input) {
        this.kmerSize = input.readInt();
        this.kmerMask = new SVKmerShort(input.readLong());
        this.kmerSet = (LargeLongHopscotchSet)kryo.readObject(input, LargeLongHopscotchSet.class);
    }

    @Override
    public boolean contains(SVKmerShort rawKmer) {
        return this.kmerSet.contains(PSKmerSet.canonicalizeAndMask(rawKmer, this.kmerSize, this.kmerMask));
    }

    public LongIterator iterator() {
        return this.kmerSet.iterator();
    }

    @Override
    public int kmerSize() {
        return this.kmerSize;
    }

    @Override
    public SVKmerShort getMask() {
        return this.kmerMask;
    }

    @Override
    public double getFalsePositiveProbability() {
        return 0.0;
    }

    public long setSize() {
        return this.kmerSet.size();
    }

    private void serialize(Kryo kryo, Output output) {
        output.writeInt(this.kmerSize);
        output.writeLong(this.kmerMask.getLong());
        kryo.writeObject(output, (Object)this.kmerSet);
        output.close();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PSKmerSet)) {
            return false;
        }
        PSKmerSet psKmerSet = (PSKmerSet)o;
        if (this.kmerSize != psKmerSet.kmerSize) {
            return false;
        }
        if (!this.kmerSet.equals(psKmerSet.kmerSet)) {
            return false;
        }
        return this.kmerMask.equals(psKmerSet.kmerMask);
    }

    public int hashCode() {
        int result = this.kmerSet.hashCode();
        result = 31 * result + this.kmerSize;
        result = 31 * result + this.kmerMask.hashCode();
        return result;
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<PSKmerSet> {
        public void write(Kryo kryo, Output output, PSKmerSet kmerSet) {
            kmerSet.serialize(kryo, output);
        }

        public PSKmerSet read(Kryo kryo, Input input, Class<PSKmerSet> klass) {
            return new PSKmerSet(kryo, input);
        }
    }
}

