/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.spark.datasources.ReferenceFileSparkSource;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSKmerBloomFilter;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSKmerCollection;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSKmerSet;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmer;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmerShort;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmerizer;
import org.broadinstitute.hellbender.tools.spark.utils.LargeLongHopscotchSet;
import org.broadinstitute.hellbender.tools.spark.utils.LongBloomFilter;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.reference.ReferenceBases;

public class PSKmerUtils {
    public static final String HOPSCOTCH_SET_EXTENSION = ".hss";
    public static final String BLOOM_FILTER_EXTENSION = ".bfi";
    private static final Logger logger = LogManager.getLogger(PSKmerUtils.class);

    protected static Collection<long[]> getMaskedKmersFromLocalReference(ReferenceFileSparkSource ref, int kSize, int kSpace, SVKmerShort mask) {
        Map<String, ReferenceBases> records;
        try {
            records = ref.getAllReferenceBases();
        }
        catch (IOException e) {
            throw new GATKException("Could not get reference bases");
        }
        ArrayList<long[]> collection = new ArrayList<long[]>(records.size());
        long totalBases = records.values().stream().mapToLong(refBases -> refBases.getBases().length).sum();
        logger.info("Generating kmers from " + totalBases + " bases in " + records.size() + " records...");
        ProgressCounter counter = new ProgressCounter(totalBases, 1000000.0, "Mbp", logger);
        for (String recName : records.keySet()) {
            byte[] bases = records.get(recName).getBases();
            long[] list = SVKmerizer.stream(bases, kSize, kSpace, (SVKmer)new SVKmerShort(kSize)).mapToLong(kmer -> PSKmerCollection.canonicalizeAndMask((SVKmerShort)kmer, kSize, mask)).toArray();
            collection.add(list);
            counter.update(bases.length);
        }
        logger.info("Finished generating kmers!");
        return collection;
    }

    public static long longArrayCollectionSize(Collection<long[]> lists) {
        return lists.stream().mapToLong(arr -> ((long[])arr).length).sum();
    }

    protected static LargeLongHopscotchSet longArrayCollectionToSet(Collection<long[]> longs, long numLongs) {
        LargeLongHopscotchSet kmerHopscotchSet = new LargeLongHopscotchSet(numLongs);
        for (long[] array : longs) {
            for (long val : array) {
                kmerHopscotchSet.add(val);
            }
        }
        return kmerHopscotchSet;
    }

    protected static LongBloomFilter longArrayCollectionToBloomFilter(Collection<long[]> longs, long numLongs, double bloomFpp) {
        LongBloomFilter bloomFilter = new LongBloomFilter(numLongs, bloomFpp);
        ProgressCounter counter = new ProgressCounter(numLongs, 1000000.0, "million kmers", logger);
        for (long[] array : longs) {
            bloomFilter.addAll(array);
            counter.update(array.length);
        }
        return bloomFilter;
    }

    public static void writeKryoObject(Object obj, String uri) {
        Output output = new Output(BucketUtils.createFile(uri));
        Kryo kryo = new Kryo();
        kryo.writeObject(output, obj);
        output.close();
    }

    public static void writeKmerSet(String uri, PSKmerSet set) {
        String filePath = uri;
        if (!uri.toLowerCase().endsWith(HOPSCOTCH_SET_EXTENSION.toLowerCase())) {
            filePath = filePath + HOPSCOTCH_SET_EXTENSION;
        }
        PSKmerUtils.writeKryoObject(set, filePath);
    }

    public static void writeKmerBloomFilter(String uri, PSKmerBloomFilter bloomFilter) {
        String filePath = uri;
        if (!uri.toLowerCase().endsWith(BLOOM_FILTER_EXTENSION.toLowerCase())) {
            filePath = filePath + BLOOM_FILTER_EXTENSION;
        }
        PSKmerUtils.writeKryoObject(bloomFilter, filePath);
    }

    public static PSKmerCollection readKmerFilter(String uri) {
        Input input = new Input(BucketUtils.openFile(uri));
        Kryo kryo = new Kryo();
        if (uri.endsWith(HOPSCOTCH_SET_EXTENSION)) {
            return (PSKmerCollection)kryo.readObject(input, PSKmerSet.class);
        }
        if (uri.endsWith(BLOOM_FILTER_EXTENSION)) {
            return (PSKmerCollection)kryo.readObject(input, PSKmerBloomFilter.class);
        }
        throw new UserException.BadInput("Unknown kmer set extension in file name " + uri);
    }

    private static final class ProgressCounter {
        long processedItems = 0L;
        long processedItemsSinceLast = 0L;
        final long initialTime;
        final long totalItems;
        final long itemsInterval;
        final double normFactor;
        final Logger logger;
        final String name;

        public ProgressCounter(long totalItems, double normFactor, String name, Logger logger) {
            this.totalItems = totalItems;
            this.itemsInterval = totalItems / 100L;
            this.initialTime = System.currentTimeMillis();
            this.normFactor = normFactor;
            this.logger = logger;
            this.name = name;
        }

        public void update(long numItems) {
            this.processedItems += numItems;
            this.processedItemsSinceLast += numItems;
            if (this.processedItemsSinceLast > this.itemsInterval) {
                long currentTime = System.currentTimeMillis();
                double percentComplete = 100.0 * (double)this.processedItems / (double)this.totalItems;
                double averageRate = (double)this.processedItems / (this.normFactor * (double)(currentTime - this.initialTime) / 60000.0);
                double estimatedTime = (double)(this.totalItems - this.processedItems) / this.normFactor / averageRate;
                String percentStr = String.format("%1$.1f", percentComplete);
                String totalStr = String.format("%1$.1f", (double)this.processedItems / this.normFactor);
                String rateStr = String.format("%1$.1f", averageRate);
                String timeStr = String.format("%1$.2f", estimatedTime);
                this.logger.info(percentStr + "% complete - " + totalStr + " " + this.name + " at " + rateStr + " " + this.name + "/min, " + timeStr + " min remaining");
                this.processedItemsSinceLast = 0L;
            }
        }
    }
}

