/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.storage.StorageLevel;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSFilter;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import scala.Tuple2;

public final class PSPairedUnpairedSplitterSpark {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    private final JavaRDD<Tuple2<List<GATKRead>, List<GATKRead>>> repartitionedReads;
    private final boolean shouldBeCached;
    private boolean isCached;

    public PSPairedUnpairedSplitterSpark(JavaRDD<GATKRead> reads, int readsPerPartitionGuess, boolean cacheReads) {
        this.repartitionedReads = PSFilter.repartitionReadsByName(reads).mapPartitions((FlatMapFunction & Serializable)iter -> PSPairedUnpairedSplitterSpark.mapPartitionsToPairedAndUnpairedLists(iter, readsPerPartitionGuess));
        this.shouldBeCached = cacheReads;
        if (cacheReads) {
            this.repartitionedReads.persist(StorageLevel.MEMORY_AND_DISK_SER());
            this.isCached = true;
        }
    }

    private static Iterator<Tuple2<List<GATKRead>, List<GATKRead>>> mapPartitionsToPairedAndUnpairedLists(Iterator<GATKRead> iter, int readsPerPartitionGuess) {
        return Collections.singletonList(PSFilter.getPairedAndUnpairedLists(iter, readsPerPartitionGuess)).iterator();
    }

    public JavaRDD<GATKRead> getPairedReads() {
        if (this.shouldBeCached && !this.isCached) {
            this.logger.warn("Getting paired reads after call to close(). Performance may be reduced.");
        }
        return this.repartitionedReads.flatMap((FlatMapFunction & Serializable)tuple -> ((List)tuple._1).iterator());
    }

    public JavaRDD<GATKRead> getUnpairedReads() {
        if (this.shouldBeCached && !this.isCached) {
            this.logger.warn("Getting unpaired reads after call to close(). Performance may be reduced.");
        }
        return this.repartitionedReads.flatMap((FlatMapFunction & Serializable)tuple -> ((List)tuple._2).iterator());
    }

    public void close() {
        if (this.isCached) {
            this.repartitionedReads.unpersist();
        }
        this.isCached = false;
    }
}

