/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;

public final class PSPathogenReferenceTaxonProperties {
    private String name;
    private String rank = null;
    private int parentTaxId = 0;
    private long length = 0L;
    private final Map<String, Long> accessions = new HashMap<String, Long>(SVUtils.hashMapCapacity(1));

    public PSPathogenReferenceTaxonProperties() {
    }

    public PSPathogenReferenceTaxonProperties(String name) {
        this();
        this.name = name;
    }

    public void addAccession(String name, long length) {
        this.accessions.put(name, length);
        this.length += length;
    }

    public boolean hasAccession(String name) {
        return this.accessions.containsKey(name);
    }

    public long getAccessionLength(String name) {
        if (this.accessions.containsKey(name)) {
            return this.accessions.get(name);
        }
        return 0L;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRank(String rank) {
        this.rank = rank;
    }

    public void setParent(int parentTaxId) {
        this.parentTaxId = parentTaxId;
    }

    public String getName() {
        return this.name;
    }

    public String getRank() {
        return this.rank;
    }

    public int getParent() {
        return this.parentTaxId;
    }

    public Set<String> getAccessions() {
        return this.accessions.keySet();
    }

    public long getTotalLength() {
        return this.length;
    }
}

