/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSTree;
import org.broadinstitute.hellbender.utils.Utils;

public final class PSPathogenTaxonScore {
    static final int DEFAULT_KINGDOM_ID = 0;
    static final String outputHeader = String.join((CharSequence)"\t", "kingdom", "score", "score_normalized", "reads", "unambiguous", "reference_length");
    private double selfScore = 0.0;
    private double descendentScore = 0.0;
    private double scoreNormalized = 0.0;
    private int totalReads = 0;
    private int unambiguousReads = 0;
    private long referenceLength = 0L;
    private int kingdomTaxonId = 0;

    public String toString() {
        return this.toString(String.valueOf(this.kingdomTaxonId));
    }

    public String toString(PSTree tree) {
        return this.toString(tree.getNameOf(this.kingdomTaxonId));
    }

    private String toString(String kingdomLabel) {
        return String.join((CharSequence)"\t", kingdomLabel, String.valueOf(this.selfScore + this.descendentScore), String.valueOf(this.scoreNormalized), String.valueOf(this.totalReads), String.valueOf(this.unambiguousReads), String.valueOf(this.referenceLength));
    }

    public PSPathogenTaxonScore add(PSPathogenTaxonScore other) {
        Utils.nonNull(other, "Cannot add taxon score to null");
        if (this.referenceLength != other.referenceLength) {
            throw new GATKException("Cannot add PSPathogenTaxonScores with different reference lengths.");
        }
        if (this.kingdomTaxonId != other.kingdomTaxonId) {
            throw new GATKException("Cannot add PSPathogenTaxonScores with different kingdoms.");
        }
        PSPathogenTaxonScore result = new PSPathogenTaxonScore();
        result.selfScore = this.selfScore + other.selfScore;
        result.descendentScore = this.descendentScore + other.descendentScore;
        result.totalReads = this.totalReads + other.totalReads;
        result.unambiguousReads = this.unambiguousReads + other.unambiguousReads;
        result.referenceLength = this.referenceLength;
        result.kingdomTaxonId = this.kingdomTaxonId;
        return result;
    }

    public double getSelfScore() {
        return this.selfScore;
    }

    public double getDescendentScore() {
        return this.descendentScore;
    }

    public double getScoreNormalized() {
        return this.scoreNormalized;
    }

    public int getTotalReads() {
        return this.totalReads;
    }

    public int getUnambiguousReads() {
        return this.unambiguousReads;
    }

    public long getReferenceLength() {
        return this.referenceLength;
    }

    public int getKingdomTaxonId() {
        return this.kingdomTaxonId;
    }

    public void addSelfScore(double selfScore) {
        Utils.validateArg(selfScore >= 0.0, "Taxon self score must be non-negative");
        this.selfScore += selfScore;
    }

    public void addDescendentScore(double descendentScore) {
        Utils.validateArg(descendentScore >= 0.0, "Taxon descendent score must be non-negative");
        this.descendentScore += descendentScore;
    }

    public void addScoreNormalized(double scoreNormalized) {
        Utils.validateArg(scoreNormalized >= 0.0, "Taxon normalized score must be non-negative");
        this.scoreNormalized += scoreNormalized;
    }

    public void addTotalReads(int totalReads) {
        Utils.validateArg(totalReads >= 0, "Taxon read count must be non-negative");
        this.totalReads += totalReads;
    }

    public void addUnambiguousReads(int unambiguousReads) {
        Utils.validateArg(unambiguousReads >= 0, "Taxon unambiguous read count must be non-negative");
        this.unambiguousReads += unambiguousReads;
    }

    public void setReferenceLength(long referenceLength) {
        Utils.validateArg(referenceLength >= 0L, "Taxon reference length must be non-negative");
        this.referenceLength = referenceLength;
    }

    public void setKingdomTaxonId(int kingdomTaxonId) {
        Utils.validateArg(kingdomTaxonId >= 0, "Taxon kingdom must be non-negative");
        this.kingdomTaxonId = kingdomTaxonId;
    }
}

