/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import java.io.Serializable;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;

public final class PSScoreArgumentCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SCORES_OUTPUT_LONG_NAME = "scores-output";
    public static final String SCORES_OUTPUT_SHORT_NAME = "SO";
    public static final String TAXONOMIC_DATABASE_LONG_NAME = "taxonomy-file";
    public static final String TAXONOMIC_DATABASE_SHORT_NAME = "T";
    public static final String SCORE_METRICS_FILE_LONG_NAME = "score-metrics";
    public static final String SCORE_METRICS_FILE_SHORT_NAME = "SM";
    public static final String SCORE_WARNINGS_FILE_LONG_NAME = "score-warnings";
    public static final String SCORE_WARNINGS_FILE_SHORT_NAME = "SW";
    public static final String MIN_SCORE_IDENTITY_LONG_NAME = "min-score-identity";
    public static final String MIN_SCORE_IDENTITY_SHORT_NAME = "min-score-identity";
    public static final String IDENTITY_MARGIN_LONG_NAME = "identity-margin";
    public static final String IDENTITY_MARGIN_SHORT_NAME = "identity-margin";
    public static final String DIVIDE_BY_GENOME_LENGTH_LONG_NAME = "divide-by-genome-length";
    public static final String DIVIDE_BY_GENOME_LENGTH_SHORT_NAME = "divide-by-genome-length";
    public static final String NOT_NORMALIZED_BY_KINGDOM_LONG_NAME = "not-normalized-by-kingdom";
    public static final String NOT_NORMALIZED_BY_KINGDOM_SHORT_NAME = "not-normalized-by-kingdom";
    public static final String SCORE_READS_PER_PARTITION_LONG_NAME = "score-reads-per-partition-estimate";
    public static final String SCORE_READS_PER_PARTITION_SHORT_NAME = "score-reads-per-partition-estimate";
    @Argument(doc="URI for the taxonomic scores output", fullName="scores-output", shortName="SO")
    public String scoresPath;
    @Argument(doc="URI to the microbe reference taxonomy database built using PathSeqBuildReferenceTaxonomy", fullName="taxonomy-file", shortName="T")
    public String taxonomyDatabasePath;
    @Argument(doc="Alignment identity score threshold, as a fraction of the read length (between 0 and 1).", fullName="min-score-identity", shortName="min-score-identity", minValue=0.0, maxValue=1.0, optional=true)
    public double minIdentity = 0.9;
    @Argument(doc="Identity margin, as a fraction of the best hit (between 0 and 1). ", fullName="identity-margin", shortName="identity-margin", minValue=0.0, maxValue=1.0, optional=true)
    public double identityMargin = 0.02;
    @Argument(doc="Divide abundance scores by each taxon's reference genome length (in millions)", fullName="divide-by-genome-length", shortName="divide-by-genome-length", optional=true)
    public boolean divideByGenomeLength = false;
    @Argument(doc="If true, normalized abundance scores will be reported as a percentage within their kingdom.", fullName="not-normalized-by-kingdom", shortName="not-normalized-by-kingdom", optional=true)
    public boolean notNormalizedByKingdom = false;
    @Argument(doc="Write accessions found in the reads header but not the taxonomy database to this file", fullName="score-warnings", shortName="SW", optional=true)
    public String headerWarningFile = null;
    @Advanced
    @Argument(doc="Estimated reads per Spark partition for scoring", fullName="score-reads-per-partition-estimate", shortName="score-reads-per-partition-estimate", minValue=1.0, optional=true)
    public int readsPerPartitionEstimate = 200000;
    @Argument(doc="Log counts of mapped and unmapped reads to this file", fullName="score-metrics", shortName="SM", optional=true)
    public String scoreMetricsFileUri = null;
}

