/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSTree;

@DefaultSerializer(value=Serializer.class)
public class PSTaxonomyDatabase {
    public final PSTree tree;
    public final Map<String, Integer> accessionToTaxId;

    public PSTaxonomyDatabase(PSTree tree, Map<String, Integer> map) {
        this.tree = tree;
        this.accessionToTaxId = map;
    }

    private PSTaxonomyDatabase(Kryo kryo, Input input) {
        boolean oldReferences = kryo.getReferences();
        kryo.setReferences(false);
        this.tree = (PSTree)kryo.readObject(input, PSTree.class);
        int setSize = input.readInt();
        this.accessionToTaxId = new HashMap<String, Integer>(setSize);
        for (int i = 0; i < setSize; ++i) {
            String key = input.readString();
            String value = input.readString();
            this.accessionToTaxId.put(key, Integer.valueOf(value));
        }
        kryo.setReferences(oldReferences);
    }

    protected void serialize(Kryo kryo, Output output) {
        boolean oldReferences = kryo.getReferences();
        kryo.setReferences(false);
        kryo.writeObject(output, (Object)this.tree);
        output.writeInt(this.accessionToTaxId.size());
        for (String key : this.accessionToTaxId.keySet()) {
            output.writeString(key);
            output.writeString(String.valueOf(this.accessionToTaxId.get(key)));
        }
        kryo.setReferences(oldReferences);
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<PSTaxonomyDatabase> {
        public void write(Kryo kryo, Output output, PSTaxonomyDatabase taxonomyDatabase) {
            taxonomyDatabase.serialize(kryo, output);
        }

        public PSTaxonomyDatabase read(Kryo kryo, Input input, Class<PSTaxonomyDatabase> klass) {
            return new PSTaxonomyDatabase(kryo, input);
        }
    }
}

