/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSTreeNode;
import org.broadinstitute.hellbender.utils.Utils;

@DefaultSerializer(value=Serializer.class)
public class PSTree {
    private final int root;
    private Map<Integer, PSTreeNode> tree;
    public static final int NULL_NODE = 0;

    public PSTree(int rootId) {
        this.tree = new HashMap<Integer, PSTreeNode>();
        this.root = rootId;
        this.tree.put(this.root, new PSTreeNode());
        this.tree.get(this.root).setName("root");
        this.tree.get(this.root).setRank("root");
        this.tree.get(this.root).setParent(0);
    }

    protected PSTree(Kryo kryo, Input input) {
        boolean oldReferences = kryo.getReferences();
        kryo.setReferences(false);
        this.root = Integer.valueOf(input.readString());
        int treeSize = input.readInt();
        this.tree = new HashMap<Integer, PSTreeNode>(treeSize);
        for (int i = 0; i < treeSize; ++i) {
            int key = input.readInt();
            PSTreeNode value = (PSTreeNode)kryo.readObject(input, PSTreeNode.class);
            this.tree.put(key, value);
        }
        kryo.setReferences(oldReferences);
    }

    private static String getAbbreviatedNodeListString(Set<Integer> nodes) {
        return nodes.stream().limit(20L).map(String::valueOf).collect(Collectors.joining(", ", "[", "]"));
    }

    protected void serialize(Kryo kryo, Output output) {
        boolean oldReferences = kryo.getReferences();
        kryo.setReferences(false);
        output.writeString(String.valueOf(this.root));
        output.writeInt(this.tree.size());
        for (int key : this.tree.keySet()) {
            output.writeInt(key);
            kryo.writeObject(output, (Object)this.tree.get(key));
        }
        kryo.setReferences(oldReferences);
    }

    public void addNode(int id, String name, int parent, long length, String rank) {
        Utils.validateArg(name != null && rank != null, "Passed a null argument to addNode()");
        Utils.validateArg(id != 0, "Passed invalid node ID to addNode()");
        Utils.validateArg(parent != 0, "Passed invalid parent ID to addNode()");
        Utils.validateArg(this.root != id, "Tried to set root attributes using addNode()");
        if (!this.tree.containsKey(id)) {
            this.tree.put(id, new PSTreeNode());
        }
        PSTreeNode node = this.tree.get(id);
        node.setName(name);
        node.setParent(parent);
        node.setLength(length);
        node.setRank(rank);
        if (!this.tree.containsKey(parent)) {
            this.tree.put(parent, new PSTreeNode());
        }
        this.tree.get(parent).addChild(id);
    }

    public Set<Integer> removeUnreachableNodes() {
        Set<Integer> reachable = this.traverse();
        HashSet<Integer> unreachable = new HashSet<Integer>(this.tree.keySet());
        unreachable.removeAll(reachable);
        this.retainNodes(reachable);
        return unreachable;
    }

    public void checkStructure() {
        for (int id : this.tree.keySet()) {
            PSTreeNode n = this.tree.get(id);
            for (int child : n.getChildren()) {
                if (!this.tree.containsKey(child)) {
                    throw new UserException.BadInput("Malformed tree detected. Node " + id + " has non-existent child " + child);
                }
                if (this.tree.get(child).getParent() == id) continue;
                throw new UserException.BadInput("Malformed tree detected. Node " + id + " has child " + child + ", whose parent is " + this.tree.get(child).getParent() + " instead of " + id);
            }
            int parent = n.getParent();
            if (parent == 0) continue;
            if (!this.tree.containsKey(parent)) {
                throw new UserException.BadInput("Malformed tree detected. Node " + id + " has non-existent parent " + parent);
            }
            if (this.tree.get(parent).getChildren().contains(id)) continue;
            throw new UserException.BadInput("Malformed tree detected. Node " + id + " has parent " + parent + ", which does not have child " + id);
        }
        Set<Integer> unreachable = this.removeUnreachableNodes();
        if (!unreachable.isEmpty()) {
            String nodesList = PSTree.getAbbreviatedNodeListString(unreachable);
            throw new UserException.BadInput("Malformed tree detected. Tree is disconnected. " + unreachable.size() + " of " + this.tree.size() + " nodes were unreachable: " + nodesList);
        }
    }

    private Set<Integer> traverse() {
        LinkedList<Integer> queue = new LinkedList<Integer>();
        HashSet<Integer> visited = new HashSet<Integer>(this.tree.size());
        queue.add(this.root);
        while (!queue.isEmpty()) {
            int id = (Integer)queue.poll();
            if (!visited.contains(id)) {
                if (!this.tree.containsKey(id)) {
                    throw new UserException.BadInput("Could not find node " + id + " while traversing the tree");
                }
            } else {
                throw new UserException.BadInput("Tree contains a cycle. Attempted to visit node " + id + " twice during a breadth-first traversal.");
            }
            queue.addAll(this.tree.get(id).getChildren());
            visited.add(id);
        }
        return visited;
    }

    public int getLCA(Collection<Integer> nodes) {
        Utils.validateArg(nodes.size() > 0, "Queried lowest common ancestor of a null set");
        ArrayList<List<Integer>> paths = new ArrayList<List<Integer>>(nodes.size());
        for (int node : nodes) {
            paths.add(this.getPathOf(node));
        }
        List firstPath = (List)paths.remove(0);
        HashSet commonNodes = new HashSet(firstPath);
        for (List list : paths) {
            commonNodes.retainAll(list);
        }
        Iterator iterator = firstPath.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!commonNodes.contains(n)) continue;
            return n;
        }
        throw new GATKException.ShouldNeverReachHereException("Could not find common ancester of node set.");
    }

    public Collection<Integer> getChildrenOf(int id) {
        Utils.validateArg(this.tree.containsKey(id), "Could not get children of node id " + id + " because it does not exist");
        return this.tree.get(id).getChildren();
    }

    public Set<Integer> getNodeIDs() {
        return this.tree.keySet();
    }

    public String getNameOf(int id) {
        Utils.validateArg(this.tree.containsKey(id), "Could not get name of node id " + id + " because it does not exist");
        return this.tree.get(id).getName();
    }

    public int getParentOf(int id) {
        Utils.validateArg(this.tree.containsKey(id), "Could not get parent of node id " + id + " because it does not exist");
        return this.tree.get(id).getParent();
    }

    public long getLengthOf(int id) {
        Utils.validateArg(this.tree.containsKey(id), "Could not get length of node id " + id + " because it does not exist");
        return this.tree.get(id).getLength();
    }

    public String getRankOf(int id) {
        Utils.validateArg(this.tree.containsKey(id), "Could not get rank of node id " + id + " because it does not exist");
        return this.tree.get(id).getRank();
    }

    public boolean hasNode(int id) {
        return this.tree.containsKey(id);
    }

    public void retainNodes(Set<Integer> idsToKeep) {
        Utils.validateArg(idsToKeep.contains(this.root), "Cannot remove root");
        HashMap<Integer, PSTreeNode> newTree = new HashMap<Integer, PSTreeNode>(idsToKeep.size());
        for (int id : this.tree.keySet()) {
            if (!idsToKeep.contains(id)) continue;
            PSTreeNode info = this.tree.get(id);
            PSTreeNode newInfo = info.copy();
            for (int child : info.getChildren()) {
                if (idsToKeep.contains(child)) continue;
                newInfo.removeChild(child);
            }
            if (!idsToKeep.contains(info.getParent())) {
                newInfo.setParent(0);
            }
            newTree.put(id, newInfo);
        }
        this.tree = newTree;
    }

    public void setNameOf(int id, String name) {
        Utils.validateArg(this.tree.containsKey(id), "Could not set name of node id " + id + " because it does not exist");
        Utils.validateArg(name != null, "Cannot set node name to null");
        Utils.validateArg(id != this.root, "Cannot set name of root");
        this.tree.get(id).setName(name);
    }

    public void setRankOf(int id, String rank) {
        Utils.validateArg(this.tree.containsKey(id), "Could not set rank of node id " + id + " because it does not exist");
        Utils.validateArg(rank != null, "Cannot set node rank to null");
        Utils.validateArg(id != this.root, "Cannot set rank of root");
        this.tree.get(id).setRank(rank);
    }

    public void setLengthOf(int id, long length) {
        Utils.validateArg(this.tree.containsKey(id), "Could not set rank of node id " + id + " because it does not exist");
        Utils.validateArg(id != this.root, "Cannot set rank of root");
        this.tree.get(id).setLength(length);
    }

    public List<Integer> getPathOf(int id) {
        ArrayList<Integer> path = new ArrayList<Integer>();
        HashSet<Integer> visitedNodes = new HashSet<Integer>(this.tree.size());
        while (id != 0) {
            if (!visitedNodes.contains(id)) {
                visitedNodes.add(id);
                if (this.tree.containsKey(id)) {
                    path.add(id);
                    id = this.tree.get(id).getParent();
                    continue;
                }
                throw new UserException.BadInput("Parent node " + id + " not found in tree while getting path");
            }
            throw new UserException.BadInput("The tree contains a cycle at node " + id);
        }
        return path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PSTree psTree = (PSTree)o;
        return this.root == psTree.root && this.tree.equals(psTree.tree);
    }

    public int hashCode() {
        int result = this.root;
        result = 31 * result + this.tree.hashCode();
        return result;
    }

    public String toString() {
        return PSTree.getAbbreviatedNodeListString(this.tree.keySet());
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<PSTree> {
        public void write(Kryo kryo, Output output, PSTree psTree) {
            psTree.serialize(kryo, output);
        }

        public PSTree read(Kryo kryo, Input input, Class<PSTree> klass) {
            return new PSTree(kryo, input);
        }
    }
}

