/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;

@DefaultSerializer(value=Serializer.class)
public class PSTreeNode {
    private String name = null;
    private String rank = null;
    private int parent = 0;
    private long length = 0L;
    private Collection<Integer> children;

    public PSTreeNode() {
        this.children = new HashSet<Integer>();
    }

    private PSTreeNode(Kryo kryo, Input input) {
        boolean oldReferences = kryo.getReferences();
        kryo.setReferences(false);
        this.name = input.readString();
        this.rank = input.readString();
        this.parent = input.readInt();
        this.length = input.readLong();
        int numChildren = input.readInt();
        this.children = new HashSet<Integer>(numChildren);
        for (int i = 0; i < numChildren; ++i) {
            this.children.add(Integer.valueOf(input.readString()));
        }
        kryo.setReferences(oldReferences);
    }

    private void serialize(Kryo kryo, Output output) {
        boolean oldReferences = kryo.getReferences();
        kryo.setReferences(false);
        output.writeString(this.name);
        output.writeString(this.rank);
        output.writeInt(this.parent);
        output.writeLong(this.length);
        output.writeInt(this.children.size());
        for (int child : this.children) {
            output.writeString(String.valueOf(child));
        }
        kryo.setReferences(oldReferences);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRank() {
        return this.rank;
    }

    public void setRank(String rank) {
        this.rank = rank;
    }

    public int getParent() {
        return this.parent;
    }

    public void setParent(int parent) {
        this.parent = parent;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public Collection<Integer> getChildren() {
        return this.children;
    }

    public void addChild(int child) {
        this.children.add(child);
    }

    public boolean removeChild(int child) {
        if (this.children.contains(child)) {
            this.children.remove(child);
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name + "," + this.rank + "," + this.parent + "," + this.length + "," + this.children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PSTreeNode that = (PSTreeNode)o;
        if (this.length != that.length) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.rank != null ? !this.rank.equals(that.rank) : that.rank != null) {
            return false;
        }
        if (this.parent != that.parent) {
            return false;
        }
        return this.children.equals(that.children);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.rank);
        result = 31 * result + this.parent;
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + this.children.hashCode();
        return result;
    }

    public PSTreeNode copy() {
        PSTreeNode n = new PSTreeNode();
        n.name = this.name;
        n.rank = this.rank;
        n.parent = this.parent;
        n.length = this.length;
        n.children = new HashSet<Integer>(this.children);
        return n;
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<PSTreeNode> {
        public void write(Kryo kryo, Output output, PSTreeNode psTreeNode) {
            psTreeNode.serialize(kryo, output);
        }

        public PSTreeNode read(Kryo kryo, Input input, Class<PSTreeNode> klass) {
            return new PSTreeNode(kryo, input);
        }
    }
}

