/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSFilterArgumentCollection;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class PSUtils {
    private static final Logger logger = LogManager.getLogger(PSUtils.class);

    public static JavaRDD<GATKRead> primaryReads(JavaRDD<GATKRead> reads) {
        return reads.filter((Function & Serializable)read -> !read.isSecondaryAlignment() && !read.isSupplementaryAlignment());
    }

    public static String[] parseCommaDelimitedArgList(String arg) {
        if (arg == null || arg.isEmpty()) {
            return new String[0];
        }
        return arg.split(",");
    }

    public static byte[] parseMask(String maskArg, int kSize) {
        String[] kmerMaskString = PSUtils.parseCommaDelimitedArgList(maskArg);
        byte[] kmerMask = new byte[kmerMaskString.length];
        for (int i = 0; i < kmerMaskString.length; ++i) {
            kmerMask[i] = (byte)Integer.parseInt(kmerMaskString[i]);
            Utils.validateArg(kmerMask[i] >= 0 && kmerMask[i] < kSize, "Invalid kmer mask index: " + kmerMaskString[i]);
        }
        return kmerMask;
    }

    public static void logItemizedWarning(Logger logger, Collection<?> items, String warning) {
        if (!items.isEmpty()) {
            String str = items.stream().map(String::valueOf).collect(Collectors.joining(", "));
            logger.warn(warning + " : " + str);
        }
    }

    public static int pathseqGetRecommendedNumReducers(String inputPath, int numReducers, int targetPartitionSize) {
        if (numReducers != 0) {
            return numReducers;
        }
        return 1 + (int)(BucketUtils.dirSize(new GATKPath(inputPath)) / (long)targetPartitionSize);
    }

    public static SAMFileHeader checkAndClearHeaderSequences(SAMFileHeader inputHeader, PSFilterArgumentCollection filterArgs, Logger logger) {
        Utils.nonNull(inputHeader, "Cannot check and clear null input header");
        Utils.nonNull(filterArgs, "Cannot check header against null filter arguments");
        Utils.nonNull(logger, "Cannot check header using null logger");
        SAMFileHeader header = inputHeader.clone();
        if (filterArgs.alignedInput && (header.getSequenceDictionary() == null || header.getSequenceDictionary().isEmpty())) {
            logger.warn("--is-host-aligned is true but the BAM header contains no sequences");
        }
        if (!filterArgs.alignedInput && header.getSequenceDictionary() != null && !header.getSequenceDictionary().isEmpty()) {
            logger.warn("--is-host-aligned is false but there are one or more sequences in the BAM header");
        }
        header.setSequenceDictionary(new SAMSequenceDictionary());
        return header;
    }

    public static int getMatchesLessDeletions(Cigar cigar, int nmTagValue) {
        Utils.nonNull(cigar, "Cannot get match score for null cigar");
        Utils.validateArg(nmTagValue >= 0, "NM tag value cannot be negative");
        int numMatchesOrMismatches = 0;
        int numDeletions = 0;
        int numInsertions = 0;
        List cigarElements = cigar.getCigarElements();
        for (CigarElement e : cigarElements) {
            if (e.getOperator().isAlignment()) {
                numMatchesOrMismatches += e.getLength();
                continue;
            }
            if (e.getOperator().equals((Object)CigarOperator.DELETION)) {
                numDeletions += e.getLength();
                continue;
            }
            if (!e.getOperator().equals((Object)CigarOperator.INSERTION)) continue;
            numInsertions += e.getLength();
        }
        int numSubstitutions = nmTagValue - numDeletions - numInsertions;
        int numMatches = numMatchesOrMismatches - numSubstitutions;
        if (numSubstitutions < 0) {
            logger.warn("Invalid arguments passed to getMatchesLessDeletions(): NM tag value was less than the number of insertions and deletions combined. Returning 0.");
            return 0;
        }
        if (numMatches < 0) {
            logger.warn("Invalid arguments passed to getMatchesLessDeletions(): Combined number of matches and mismatches was less than the number of substitutions. Returning 0.");
            return 0;
        }
        return numMatches - numDeletions;
    }
}

