/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import htsjdk.samtools.SAMFileHeader;
import java.io.IOException;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.storage.StorageLevel;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.MetagenomicsProgramGroup;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.engine.spark.datasources.ReadsSparkSink;
import org.broadinstitute.hellbender.engine.spark.datasources.ReadsSparkSource;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSBwaAlignerSpark;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSBwaArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSBwaUtils;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadsWriteFormat;
import scala.Tuple2;

@CommandLineProgramProperties(summary="Align reads to a microbe reference using BWA-MEM and Spark. Second step in the PathSeq pipeline.", oneLineSummary="Step 2: Aligns reads to the microbe reference", programGroup=MetagenomicsProgramGroup.class)
@DocumentedFeature
public final class PathSeqBwaSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    public static final String PAIRED_INPUT_LONG_NAME = "paired-input";
    public static final String UNPAIRED_INPUT_LONG_NAME = "unpaired-input";
    public static final String PAIRED_OUTPUT_LONG_NAME = "paired-output";
    public static final String UNPAIRED_OUTPUT_LONG_NAME = "unpaired-output";
    @Argument(doc="Input queryname-sorted BAM containing only paired reads", fullName="paired-input", optional=true)
    public String inputPaired = null;
    @Argument(doc="Input BAM containing only unpaired reads", fullName="unpaired-input", optional=true)
    public String inputUnpaired = null;
    @Argument(doc="Output BAM containing only paired reads", fullName="paired-output", optional=true)
    public String outputPaired = null;
    @Argument(doc="Output BAM containing only unpaired reads", fullName="unpaired-output", optional=true)
    public String outputUnpaired = null;
    @ArgumentCollection
    public PSBwaArgumentCollection bwaArgs = new PSBwaArgumentCollection();

    private Tuple2<SAMFileHeader, JavaRDD<GATKRead>> loadBam(String path, ReadsSparkSource readsSource) {
        if (path == null) {
            return null;
        }
        if (BucketUtils.fileExists(path)) {
            SAMFileHeader header = readsSource.getHeader(new GATKPath(path), null);
            if (header.getSequenceDictionary() != null && !header.getSequenceDictionary().isEmpty()) {
                throw new UserException.BadInput("Input BAM should be unaligned, but found one or more sequences in the header.");
            }
            PSBwaUtils.addReferenceSequencesToHeader(header, this.bwaArgs.microbeDictionary);
            JavaRDD<GATKRead> reads = readsSource.getParallelReads(new GATKPath(path), null, null, this.bamPartitionSplitSize);
            return new Tuple2((Object)header, reads);
        }
        this.logger.warn("Could not find file " + path + ". Skipping...");
        return null;
    }

    private void writeBam(JavaRDD<GATKRead> reads, String inputBamPath, boolean isPaired, JavaSparkContext ctx, SAMFileHeader header) {
        reads.persist(StorageLevel.MEMORY_AND_DISK_SER());
        header = PSBwaUtils.removeUnmappedHeaderSequences(header, reads, this.logger);
        String outputPath = isPaired ? this.outputPaired : this.outputUnpaired;
        try {
            ReadsSparkSink.writeReads(ctx, outputPath, null, reads, header, this.shardedOutput ? ReadsWriteFormat.SHARDED : ReadsWriteFormat.SINGLE, PSUtils.pathseqGetRecommendedNumReducers(inputBamPath, this.numReducers, this.getTargetPartitionSize()), this.shardedPartsDir, true, this.splittingIndexGranularity);
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile(outputPath, "Writing failed", (Exception)e);
        }
    }

    private boolean alignBam(String inputBamPath, PSBwaAlignerSpark aligner, boolean isPaired, JavaSparkContext ctx, ReadsSparkSource readsSource) {
        Tuple2<SAMFileHeader, JavaRDD<GATKRead>> loadedBam = this.loadBam(inputBamPath, readsSource);
        if (loadedBam == null) {
            return false;
        }
        SAMFileHeader header = (SAMFileHeader)loadedBam._1;
        JavaRDD reads = (JavaRDD)loadedBam._2;
        Utils.nonNull(header);
        Utils.nonNull(reads);
        if (isPaired && !header.getSortOrder().equals((Object)SAMFileHeader.SortOrder.queryname)) {
            throw new UserException.BadInput("Paired input BAM must be sorted by queryname");
        }
        JavaRDD<GATKRead> alignedReads = aligner.doBwaAlignment((JavaRDD<GATKRead>)reads, isPaired, (Broadcast<SAMFileHeader>)ctx.broadcast((Object)header));
        this.writeBam(alignedReads, inputBamPath, isPaired, ctx, header);
        return true;
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        if (!this.readArguments.getReadPathSpecifiers().isEmpty()) {
            throw new UserException.BadInput("Please use --paired-input or --unpaired-input instead of --input");
        }
        Utils.validateArg(!(this.outputPaired != null && !new GATKPath(this.outputPaired).isBam() || this.outputUnpaired != null && !new GATKPath(this.outputUnpaired).isBam()), "Only BAM output is supported");
        ReadsSparkSource readsSource = new ReadsSparkSource(ctx, this.readArguments.getReadValidationStringency());
        PSBwaAlignerSpark aligner = new PSBwaAlignerSpark(ctx, this.bwaArgs);
        boolean bPairedSuccess = this.alignBam(this.inputPaired, aligner, true, ctx, readsSource);
        boolean bUnpairedSuccess = this.alignBam(this.inputUnpaired, aligner, false, ctx, readsSource);
        if (!bPairedSuccess && !bUnpairedSuccess) {
            throw new UserException.BadInput("No reads were loaded. Ensure --paired-input and/or --unpaired-input are set and valid.");
        }
        aligner.close();
    }
}

