/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import htsjdk.samtools.SAMFileHeader;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.GATKPlugin.GATKReadFilterPluginDescriptor;
import org.broadinstitute.hellbender.cmdline.programgroups.MetagenomicsProgramGroup;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSFilter;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSFilterArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSUtils;
import org.broadinstitute.hellbender.tools.spark.pathseq.loggers.PSFilterEmptyLogger;
import org.broadinstitute.hellbender.tools.spark.pathseq.loggers.PSFilterFileLogger;
import org.broadinstitute.hellbender.tools.spark.pathseq.loggers.PSFilterLogger;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import scala.Tuple2;

@CommandLineProgramProperties(summary="Filters low complexity, low quality, duplicate, and host reads. First step in the PathSeq pipeline.", oneLineSummary="Step 1: Filters low quality, low complexity, duplicate, and host reads", programGroup=MetagenomicsProgramGroup.class)
@DocumentedFeature
public final class PathSeqFilterSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    public static final String PAIRED_OUTPUT_LONG_NAME = "paired-output";
    public static final String UNPAIRED_OUTPUT_LONG_NAME = "unpaired-output";
    @Argument(doc="Output BAM containing only paired reads", fullName="paired-output", optional=true)
    public String outputPaired = null;
    @Argument(doc="Output BAM containing only unpaired reads", fullName="unpaired-output", optional=true)
    public String outputUnpaired = null;
    @ArgumentCollection
    public PSFilterArgumentCollection filterArgs = new PSFilterArgumentCollection();

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        Tuple2<JavaRDD<GATKRead>, JavaRDD<GATKRead>> filterResult;
        this.filterArgs.doReadFilterArgumentWarnings((GATKReadFilterPluginDescriptor)((Object)this.getCommandLineParser().getPluginDescriptor(GATKReadFilterPluginDescriptor.class)), this.logger);
        SAMFileHeader header = PSUtils.checkAndClearHeaderSequences(this.getHeaderForReads(), this.filterArgs, this.logger);
        JavaRDD<GATKRead> reads = this.getReads();
        PSFilter filter = new PSFilter(ctx, this.filterArgs, header);
        try (PSFilterLogger filterLogger = this.filterArgs.filterMetricsFileUri != null ? new PSFilterFileLogger(this.getMetricsFile(), this.filterArgs.filterMetricsFileUri) : new PSFilterEmptyLogger();){
            filterResult = filter.doFilter(reads, filterLogger);
        }
        JavaRDD pairedReads = (JavaRDD)filterResult._1;
        JavaRDD unpairedReads = (JavaRDD)filterResult._2;
        if (!pairedReads.isEmpty()) {
            header.setSortOrder(SAMFileHeader.SortOrder.queryname);
            this.writeReads(ctx, this.outputPaired, (JavaRDD<GATKRead>)pairedReads, header, true);
        } else {
            this.logger.info("No paired reads to write - BAM will not be written.");
        }
        if (!unpairedReads.isEmpty()) {
            header.setSortOrder(SAMFileHeader.SortOrder.unsorted);
            this.writeReads(ctx, this.outputUnpaired, (JavaRDD<GATKRead>)unpairedReads, header, true);
        } else {
            this.logger.info("No unpaired reads to write - BAM will not be written.");
        }
        filter.close();
    }
}

