/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMSequenceRecord;
import java.io.IOException;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.MetagenomicsProgramGroup;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.engine.spark.datasources.ReadsSparkSink;
import org.broadinstitute.hellbender.engine.spark.datasources.ReadsSparkSource;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSScoreArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSScorer;
import org.broadinstitute.hellbender.tools.spark.pathseq.PSUtils;
import org.broadinstitute.hellbender.tools.spark.pathseq.loggers.PSScoreFileLogger;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadsWriteFormat;
import scala.Tuple2;

@CommandLineProgramProperties(summary="Classify reads and estimate abundances of each taxon in the reference. This is the third and final step of the PathSeq pipeline.", oneLineSummary="Step 3: Classifies pathogen-aligned reads and generates abundance scores", programGroup=MetagenomicsProgramGroup.class)
@DocumentedFeature
public class PathSeqScoreSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    public static final String PAIRED_INPUT_LONG_NAME = "paired-input";
    public static final String UNPAIRED_INPUT_LONG_NAME = "unpaired-input";
    @Argument(doc="Input queryname-sorted BAM containing only paired reads", fullName="paired-input", optional=true)
    public String pairedInput = null;
    @Argument(doc="Input BAM containing only unpaired reads", fullName="unpaired-input", optional=true)
    public String unpairedInput = null;
    @Argument(doc="Output BAM", fullName="output", shortName="O", optional=true)
    public String outputPath = null;
    @ArgumentCollection
    public PSScoreArgumentCollection scoreArgs = new PSScoreArgumentCollection();
    private int recommendedNumReducers = 0;

    private Tuple2<JavaRDD<GATKRead>, SAMFileHeader> readInputWithHeader(String path, ReadsSparkSource readsSource) {
        if (path != null) {
            if (BucketUtils.fileExists(path)) {
                this.recommendedNumReducers += PSUtils.pathseqGetRecommendedNumReducers(path, this.numReducers, this.getTargetPartitionSize());
                SAMFileHeader header = readsSource.getHeader(new GATKPath(path), null);
                JavaRDD<GATKRead> reads = readsSource.getParallelReads(new GATKPath(path), null, null, this.bamPartitionSplitSize, this.useNio);
                reads = PSUtils.primaryReads(reads);
                return new Tuple2(reads, (Object)header);
            }
            this.logger.warn("Could not find file " + path + ". Skipping...");
        }
        return new Tuple2(null, null);
    }

    static SAMFileHeader joinBamHeaders(SAMFileHeader pairedHeader, SAMFileHeader unpairedHeader) {
        SAMFileHeader header;
        if (pairedHeader != null) {
            header = pairedHeader;
            if (unpairedHeader != null && !header.equals((Object)unpairedHeader)) {
                for (SAMSequenceRecord rec : unpairedHeader.getSequenceDictionary().getSequences()) {
                    if (header.getSequenceDictionary().getSequence(rec.getSequenceName()) != null) continue;
                    header.addSequence(rec);
                }
                for (SAMSequenceRecord rec : unpairedHeader.getReadGroups()) {
                    if (header.getReadGroup(rec.getReadGroupId()) != null) continue;
                    header.addReadGroup((SAMReadGroupRecord)rec);
                }
            }
        } else if (unpairedHeader != null) {
            header = unpairedHeader;
        } else {
            throw new UserException.BadInput("No headers were loaded");
        }
        return header;
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        if (!this.readArguments.getReadPathSpecifiers().isEmpty()) {
            throw new UserException.BadInput("Please use --paired-input or --unpaired-input instead of --input");
        }
        ReadsSparkSource readsSource = new ReadsSparkSource(ctx, this.readArguments.getReadValidationStringency());
        Tuple2<JavaRDD<GATKRead>, SAMFileHeader> pairedData = this.readInputWithHeader(this.pairedInput, readsSource);
        Tuple2<JavaRDD<GATKRead>, SAMFileHeader> unpairedData = this.readInputWithHeader(this.unpairedInput, readsSource);
        JavaRDD pairedReads = (JavaRDD)pairedData._1;
        SAMFileHeader pairedHeader = (SAMFileHeader)pairedData._2;
        JavaRDD unpairedReads = (JavaRDD)unpairedData._1;
        SAMFileHeader unpairedHeader = (SAMFileHeader)unpairedData._2;
        if (pairedHeader != null && !pairedHeader.getSortOrder().equals((Object)SAMFileHeader.SortOrder.queryname)) {
            throw new UserException.BadInput("Paired input BAM must be sorted by queryname");
        }
        SAMFileHeader header = PathSeqScoreSpark.joinBamHeaders(pairedHeader, unpairedHeader);
        PSScorer scorer = new PSScorer(this.scoreArgs);
        JavaRDD<GATKRead> readsFinal = scorer.scoreReads(ctx, (JavaRDD<GATKRead>)pairedReads, (JavaRDD<GATKRead>)unpairedReads, header);
        if (this.scoreArgs.scoreMetricsFileUri != null) {
            try (PSScoreFileLogger scoreLogger = new PSScoreFileLogger(this.getMetricsFile(), this.scoreArgs.scoreMetricsFileUri);){
                scoreLogger.logReadCounts(readsFinal);
            }
        }
        if (this.outputPath != null) {
            try {
                ReadsSparkSink.writeReads(ctx, this.outputPath, null, readsFinal, header, this.shardedOutput ? ReadsWriteFormat.SHARDED : ReadsWriteFormat.SINGLE, this.recommendedNumReducers, this.shardedPartsDir, true, this.splittingIndexGranularity);
            }
            catch (IOException e) {
                throw new UserException.CouldNotCreateOutputFile(this.outputPath, "writing failed", (Exception)e);
            }
        }
    }
}

