/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq.loggers;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import org.apache.spark.api.java.JavaRDD;
import org.broadinstitute.hellbender.metrics.MetricsUtils;
import org.broadinstitute.hellbender.tools.spark.pathseq.loggers.PSFilterLogger;
import org.broadinstitute.hellbender.tools.spark.pathseq.loggers.PSFilterMetrics;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class PSFilterFileLogger
implements PSFilterLogger {
    private final PSFilterMetrics metrics;
    private final MetricsFile<PSFilterMetrics, Long> metricsFile;
    private final String metricsOutputPath;

    public PSFilterFileLogger(MetricsFile<PSFilterMetrics, Long> metricsFile, String metricsOutputPath) {
        Utils.nonNull(metricsFile, "Filter logger parameter metricsFile cannot be null");
        Utils.nonNull(metricsOutputPath, "Filter logger parameter metricsOutputPath cannot be null");
        this.metrics = new PSFilterMetrics();
        this.metricsFile = metricsFile;
        this.metricsOutputPath = metricsOutputPath;
    }

    @Override
    public void logPrimaryReads(JavaRDD<GATKRead> reads) {
        Utils.nonNull(reads, "Filter logging parameter reads cannot be null");
        this.metrics.PRIMARY_READS = reads.count();
    }

    @Override
    public void logReadsAfterPrealignedHostFilter(JavaRDD<GATKRead> reads) {
        Utils.nonNull(reads, "Filter logging parameter reads cannot be null");
        this.metrics.READS_AFTER_PREALIGNED_HOST_FILTER = reads.count();
    }

    @Override
    public void logReadsAfterQualityFilter(JavaRDD<GATKRead> reads) {
        Utils.nonNull(reads, "Filter logging parameter reads cannot be null");
        this.metrics.READS_AFTER_QUALITY_AND_COMPLEXITY_FILTER = reads.count();
    }

    @Override
    public void logReadsAfterHostFilter(JavaRDD<GATKRead> reads) {
        Utils.nonNull(reads, "Filter logging parameter reads cannot be null");
        this.metrics.READS_AFTER_HOST_FILTER = reads.count();
    }

    @Override
    public void logReadsAfterDeduplication(JavaRDD<GATKRead> reads) {
        Utils.nonNull(reads, "Filter logging parameter reads cannot be null");
        this.metrics.READS_AFTER_DEDUPLICATION = reads.count();
    }

    @Override
    public void logFinalPairedReads(JavaRDD<GATKRead> reads) {
        Utils.nonNull(reads, "Filter logging parameter reads cannot be null");
        this.metrics.FINAL_PAIRED_READS = reads.count();
    }

    @Override
    public void close() {
        this.metrics.computeDerivedMetrics();
        this.metricsFile.addMetric((MetricBase)this.metrics);
        MetricsUtils.saveMetrics(this.metricsFile, this.metricsOutputPath);
    }
}

