/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq.loggers;

import htsjdk.samtools.metrics.MetricBase;

public final class PSFilterMetrics
extends MetricBase {
    public Long PRIMARY_READS;
    public Long READS_AFTER_PREALIGNED_HOST_FILTER;
    public Long READS_AFTER_QUALITY_AND_COMPLEXITY_FILTER;
    public Long READS_AFTER_HOST_FILTER;
    public Long READS_AFTER_DEDUPLICATION;
    public Long FINAL_PAIRED_READS;
    public Long FINAL_UNPAIRED_READS;
    public Long FINAL_TOTAL_READS;
    public Long LOW_QUALITY_OR_LOW_COMPLEXITY_READS_FILTERED;
    public Long HOST_READS_FILTERED;
    public Long DUPLICATE_READS_FILTERED;

    public void computeDerivedMetrics() {
        if (this.PRIMARY_READS == null || this.READS_AFTER_PREALIGNED_HOST_FILTER == null || this.READS_AFTER_QUALITY_AND_COMPLEXITY_FILTER == null || this.READS_AFTER_HOST_FILTER == null || this.READS_AFTER_DEDUPLICATION == null || this.FINAL_PAIRED_READS == null) {
            throw new IllegalStateException("Cannot compute metrics if primary, pre-aligned host, quality, host, duplicate, or final paired read counts are not initialized");
        }
        this.FINAL_TOTAL_READS = this.READS_AFTER_DEDUPLICATION;
        this.FINAL_UNPAIRED_READS = this.FINAL_TOTAL_READS - this.FINAL_PAIRED_READS;
        this.LOW_QUALITY_OR_LOW_COMPLEXITY_READS_FILTERED = this.READS_AFTER_PREALIGNED_HOST_FILTER - this.READS_AFTER_QUALITY_AND_COMPLEXITY_FILTER;
        this.HOST_READS_FILTERED = this.PRIMARY_READS - this.READS_AFTER_PREALIGNED_HOST_FILTER + this.READS_AFTER_QUALITY_AND_COMPLEXITY_FILTER - this.READS_AFTER_HOST_FILTER;
        this.DUPLICATE_READS_FILTERED = this.READS_AFTER_HOST_FILTER - this.READS_AFTER_DEDUPLICATION;
    }
}

