/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pathseq.loggers;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.broadinstitute.hellbender.metrics.MetricsUtils;
import org.broadinstitute.hellbender.tools.spark.pathseq.loggers.PSScoreLogger;
import org.broadinstitute.hellbender.tools.spark.pathseq.loggers.PSScoreMetrics;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class PSScoreFileLogger
implements PSScoreLogger {
    private final PSScoreMetrics metrics;
    private final MetricsFile<PSScoreMetrics, Long> metricsFile;
    private final String metricsOutputPath;

    public PSScoreFileLogger(MetricsFile<PSScoreMetrics, Long> metricsFile, String metricsOutputPath) {
        Utils.nonNull(metricsFile, "Score filter parameter metricsFile cannot be null");
        Utils.nonNull(metricsOutputPath, "Score filter parameter metricsOutputPath cannot be null");
        this.metrics = new PSScoreMetrics();
        this.metricsFile = metricsFile;
        this.metricsOutputPath = metricsOutputPath;
    }

    @Override
    public void logReadCounts(JavaRDD<GATKRead> reads) {
        Utils.nonNull(reads, "Score logging parameter reads cannot be null");
        long numReads = reads.count();
        long numMappedReads = reads.filter((Function & Serializable)read -> read.hasAttribute("YP")).count();
        long numUnmappedReads = numReads - numMappedReads;
        this.metrics.UNMAPPED_READS = numUnmappedReads;
        this.metrics.MAPPED_READS = numMappedReads;
    }

    @Override
    public void close() {
        this.metricsFile.addMetric((MetricBase)this.metrics);
        MetricsUtils.saveMetrics(this.metricsFile, this.metricsOutputPath);
    }
}

