/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pipelines;

import java.io.Serializable;
import java.util.List;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.tools.ApplyBQSRUniqueArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.transforms.ApplyBQSRSparkFn;
import org.broadinstitute.hellbender.tools.spark.transforms.BaseRecalibratorSparkFn;
import org.broadinstitute.hellbender.tools.walkers.bqsr.BaseRecalibrator;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationArgumentCollection;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationReport;
import org.broadinstitute.hellbender.utils.spark.JoinReadsWithVariants;
import org.broadinstitute.hellbender.utils.variant.GATKVariant;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="This tools performs 2 steps of BQSR - creation of recalibration tables and rewriting of the bam, without writing the tables to disk. ", oneLineSummary="Both steps of BQSR (BaseRecalibrator and ApplyBQSR) on Spark", usageExample="BQSRPipelineSpark -I in.bam --known-sites in.vcf -O out.bam", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
@BetaFeature
public final class BQSRPipelineSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    static final String USAGE_ONE_LINE_SUMMARY = "Both steps of BQSR (BaseRecalibrator and ApplyBQSR) on Spark";
    static final String USAGE_SUMMARY = "This tools performs 2 steps of BQSR - creation of recalibration tables and rewriting of the bam, without writing the tables to disk. ";
    @Argument(doc="the known variants", fullName="known-sites", optional=false)
    protected List<String> knownVariants;
    @Argument(doc="the output bam", shortName="O", fullName="output", optional=false)
    protected String output;
    @ArgumentCollection(doc="all the command line arguments for BQSR and its covariates")
    private final RecalibrationArgumentCollection bqsrArgs = new RecalibrationArgumentCollection();
    @ArgumentCollection
    public ApplyBQSRUniqueArgumentCollection applyBqsrArgs = new ApplyBQSRUniqueArgumentCollection();

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        String referenceFileName = BQSRPipelineSpark.addReferenceFilesForSpark(ctx, this.referenceArguments.getReferencePath());
        List<String> localKnownSitesFilePaths = BQSRPipelineSpark.addVCFsForSpark(ctx, this.knownVariants);
        JavaRDD<GATKRead> initialReads = this.getReads();
        ReadFilter bqsrReadFilter = ReadFilter.fromList(BaseRecalibrator.getBQSRSpecificReadFilterList(), this.getHeaderForReads());
        JavaRDD filteredReadsForBQSR = initialReads.filter((Function & Serializable)read -> bqsrReadFilter.test((GATKRead)read));
        JavaPairRDD<GATKRead, Iterable<GATKVariant>> readsWithVariants = JoinReadsWithVariants.join((JavaRDD<GATKRead>)filteredReadsForBQSR, localKnownSitesFilePaths);
        RecalibrationReport bqsrReport = BaseRecalibratorSparkFn.apply(readsWithVariants, this.getHeaderForReads(), referenceFileName, this.bqsrArgs);
        Broadcast reportBroadcast = ctx.broadcast((Object)bqsrReport);
        JavaRDD<GATKRead> finalReads = ApplyBQSRSparkFn.apply(initialReads, (Broadcast<RecalibrationReport>)reportBroadcast, this.getHeaderForReads(), this.applyBqsrArgs.toApplyBQSRArgumentCollection(this.bqsrArgs));
        this.writeReads(ctx, this.output, finalReads);
    }
}

