/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pipelines;

import java.io.IOException;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.argumentcollections.MarkDuplicatesSparkArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.SequenceDictionaryValidationArgumentCollection;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.engine.spark.datasources.ReadsSparkSink;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.bwa.BwaArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.bwa.BwaSparkEngine;
import org.broadinstitute.hellbender.tools.spark.transforms.markduplicates.MarkDuplicatesSpark;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadsWriteFormat;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;
import picard.sam.markduplicates.util.OpticalDuplicateFinder;

@CommandLineProgramProperties(summary="Takes name-sorted file and runs BWA and MarkDuplicates.", oneLineSummary="Takes name-sorted file and runs BWA and MarkDuplicates.", usageExample="BwaAndMarkDuplicatesPipelineSpark -I single.bam -R referenceURL -O file:///tmp/output.bam", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
@BetaFeature
public final class BwaAndMarkDuplicatesPipelineSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    @ArgumentCollection
    public final BwaArgumentCollection bwaArgs = new BwaArgumentCollection();
    @Argument(doc="the output bam", shortName="O", fullName="output")
    protected String output;
    @ArgumentCollection
    protected MarkDuplicatesSparkArgumentCollection markDuplicatesSparkArgumentCollection = new MarkDuplicatesSparkArgumentCollection();

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    protected SequenceDictionaryValidationArgumentCollection getSequenceDictionaryValidationArgumentCollection() {
        return new SequenceDictionaryValidationArgumentCollection.NoValidationCollection();
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        try (BwaSparkEngine bwaEngine = new BwaSparkEngine(ctx, this.referenceArguments.getReferenceFileName(), this.bwaArgs.indexImageFile, this.getHeaderForReads(), this.getReferenceSequenceDictionary());){
            ReadFilter filter = this.makeReadFilter(bwaEngine.getHeader());
            JavaRDD alignedReads = bwaEngine.alignPaired(this.getUnfilteredReads()).filter(filter::test);
            JavaRDD<GATKRead> markedReads = MarkDuplicatesSpark.mark((JavaRDD<GATKRead>)alignedReads, bwaEngine.getHeader(), new OpticalDuplicateFinder(), this.markDuplicatesSparkArgumentCollection, this.getRecommendedNumReducers());
            try {
                ReadsSparkSink.writeReads(ctx, this.output, this.referenceArguments.getReferenceSpecifier(), markedReads, bwaEngine.getHeader(), this.shardedOutput ? ReadsWriteFormat.SHARDED : ReadsWriteFormat.SINGLE, this.getRecommendedNumReducers(), this.shardedPartsDir, true, this.splittingIndexGranularity);
            }
            catch (IOException e) {
                throw new GATKException("unable to write bam: " + e);
            }
        }
    }
}

