/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pipelines;

import java.io.PrintStream;
import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.CoverageAnalysisProgramGroup;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@CommandLineProgramProperties(summary="Counts bases in the input SAM/BAM", oneLineSummary="Counts bases in the input SAM/BAM", programGroup=CoverageAnalysisProgramGroup.class)
@DocumentedFeature
public final class CountBasesSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    @Argument(doc="uri for the output file: a local file path", shortName="O", fullName="output", optional=true)
    public String out;

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        JavaRDD<GATKRead> reads = this.getReads();
        long count = (Long)reads.map((Function & Serializable)r -> r.getLength()).fold((Object)0L, Long::sum);
        System.out.println(count);
        if (this.out != null) {
            try (PrintStream ps = new PrintStream(BucketUtils.createFile(this.out));){
                ps.print(count);
            }
        }
    }
}

