/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pipelines;

import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.CoverageAnalysisProgramGroup;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature
@CommandLineProgramProperties(summary="Counts reads in the input SAM/BAM", oneLineSummary="Counts reads in the input SAM/BAM", programGroup=CoverageAnalysisProgramGroup.class)
public final class CountReadsSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    @Argument(doc="uri for the output file: a local file path", shortName="O", fullName="output", optional=true)
    public String out;

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return Collections.singletonList(ReadFilterLibrary.ALLOW_ALL_READS);
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        JavaRDD<GATKRead> reads = this.getReads();
        long count = reads.count();
        System.out.println(count);
        if (this.out != null) {
            try (PrintStream ps = new PrintStream(BucketUtils.createFile(this.out));){
                ps.print(count);
            }
        }
    }
}

