/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pipelines;

import htsjdk.variant.variantcontext.VariantContext;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLinePluginDescriptor;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.engine.spark.datasources.VariantsSparkSource;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import picard.cmdline.programgroups.VariantEvaluationProgramGroup;

@CommandLineProgramProperties(summary="Counts variants in the input VCF", oneLineSummary="CountVariants on Spark", programGroup=VariantEvaluationProgramGroup.class)
@DocumentedFeature
public final class CountVariantsSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    @Argument(doc="uri for the input file: a local file path", shortName="V", fullName="variant", optional=false)
    public String input;
    @Argument(doc="uri for the output file: a local file path", shortName="O", fullName="output", optional=true)
    public String out;

    @Override
    public List<? extends CommandLinePluginDescriptor<?>> getPluginDescriptors() {
        return new ArrayList();
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        VariantsSparkSource vss = new VariantsSparkSource(ctx);
        JavaRDD<VariantContext> variants = vss.getParallelVariantContexts(this.input, this.getIntervals());
        long count = variants.count();
        System.out.println(count);
        if (this.out != null) {
            try (PrintStream ps = new PrintStream(BucketUtils.createFile(this.out));){
                ps.print(count);
            }
        }
    }
}

