/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pipelines;

import java.io.PrintStream;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.tools.FlagStat;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;

@DocumentedFeature
@CommandLineProgramProperties(summary="Spark tool to accumulate flag statistics given a BAM file, e.g. total number of reads with QC failure flag set,number of duplicates, percentage mapped etc.", oneLineSummary="Spark tool to accumulate flag statistics", programGroup=DiagnosticsAndQCProgramGroup.class)
public final class FlagStatSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    @Argument(doc="uri for the output file: a local file path", shortName="O", fullName="output", optional=true)
    public String out;

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        JavaRDD<GATKRead> reads = this.getReads();
        FlagStat.FlagStatus result = (FlagStat.FlagStatus)reads.aggregate((Object)new FlagStat.FlagStatus(), FlagStat.FlagStatus::add, FlagStat.FlagStatus::merge);
        System.out.println(result);
        if (this.out != null) {
            try (PrintStream ps = new PrintStream(BucketUtils.createFile(this.out));){
                ps.print(result);
            }
        }
    }
}

