/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pipelines;

import htsjdk.variant.variantcontext.VariantContext;
import java.io.IOException;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.spark.VariantWalkerContext;
import org.broadinstitute.hellbender.engine.spark.VariantWalkerSpark;
import org.broadinstitute.hellbender.engine.spark.datasources.VariantsSparkSink;
import org.broadinstitute.hellbender.exceptions.UserException;
import picard.cmdline.programgroups.VariantManipulationProgramGroup;

@CommandLineProgramProperties(summary="Prints out variants from the input VCF file.", oneLineSummary="Prints out variants from the input VCF.", programGroup=VariantManipulationProgramGroup.class)
@DocumentedFeature
public final class PrintVariantsSpark
extends VariantWalkerSpark {
    private static final long serialVersionUID = 1L;
    @Argument(doc="Uri for the output file (a local file path).", shortName="O", fullName="output", optional=false)
    public String output;

    @Override
    protected void processVariants(JavaRDD<VariantWalkerContext> rdd, JavaSparkContext ctx) {
        try {
            VariantsSparkSink.writeVariants(ctx, this.output, (JavaRDD<VariantContext>)rdd.map(VariantWalkerContext::getVariant), this.getHeaderForVariants(), this.createOutputVariantIndex, false);
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile(this.output, "writing failed", (Exception)e);
        }
    }
}

