/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pipelines;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.argumentcollections.MarkDuplicatesSparkArgumentCollection;
import org.broadinstitute.hellbender.cmdline.programgroups.ShortVariantDiscoveryProgramGroup;
import org.broadinstitute.hellbender.engine.Shard;
import org.broadinstitute.hellbender.engine.ShardBoundary;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.spark.AssemblyRegionArgumentCollection;
import org.broadinstitute.hellbender.engine.spark.AssemblyRegionReadShardArgumentCollection;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.tools.ApplyBQSRUniqueArgumentCollection;
import org.broadinstitute.hellbender.tools.HaplotypeCallerSpark;
import org.broadinstitute.hellbender.tools.spark.bwa.BwaArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.bwa.BwaSparkEngine;
import org.broadinstitute.hellbender.tools.spark.transforms.ApplyBQSRSparkFn;
import org.broadinstitute.hellbender.tools.spark.transforms.BaseRecalibratorSparkFn;
import org.broadinstitute.hellbender.tools.spark.transforms.markduplicates.MarkDuplicatesSpark;
import org.broadinstitute.hellbender.tools.walkers.annotator.Annotation;
import org.broadinstitute.hellbender.tools.walkers.bqsr.BaseRecalibrator;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.HaplotypeCallerArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.HaplotypeCallerEngine;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReferenceConfidenceMode;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationArgumentCollection;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationReport;
import org.broadinstitute.hellbender.utils.spark.JoinReadsWithVariants;
import org.broadinstitute.hellbender.utils.spark.SparkUtils;
import org.broadinstitute.hellbender.utils.variant.GATKVariant;
import picard.sam.markduplicates.util.OpticalDuplicateFinder;

@CommandLineProgramProperties(summary="Takes unaligned or aligned reads and runs BWA (if specified), MarkDuplicates, BQSR, and HaplotypeCaller. The final result is analysis-ready variants.", oneLineSummary="Runs BWA (if specified), MarkDuplicates, BQSR, and HaplotypeCaller on unaligned or aligned reads to generate a VCF.", programGroup=ShortVariantDiscoveryProgramGroup.class)
@DocumentedFeature
@BetaFeature
public class ReadsPipelineSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    static final String USAGE_ONE_LINE_SUMMARY = "Runs BWA (if specified), MarkDuplicates, BQSR, and HaplotypeCaller on unaligned or aligned reads to generate a VCF.";
    static final String USAGE_SUMMARY = "Takes unaligned or aligned reads and runs BWA (if specified), MarkDuplicates, BQSR, and HaplotypeCaller. The final result is analysis-ready variants.";
    @Argument(doc="whether to perform alignment using BWA-MEM", fullName="align", optional=true)
    private boolean align;
    @Argument(doc="the known variants", fullName="known-sites", optional=false)
    protected List<String> knownVariants;
    @Argument(doc="the output vcf", shortName="O", fullName="output", optional=false)
    protected String output;
    @Argument(doc="the output bam", fullName="output-bam", optional=true)
    protected String outputBam;
    @ArgumentCollection
    protected MarkDuplicatesSparkArgumentCollection markDuplicatesSparkArgumentCollection = new MarkDuplicatesSparkArgumentCollection();
    @ArgumentCollection
    public final BwaArgumentCollection bwaArgs = new BwaArgumentCollection();
    @ArgumentCollection(doc="all the command line arguments for BQSR and its covariates")
    private final RecalibrationArgumentCollection bqsrArgs = new RecalibrationArgumentCollection();
    @ArgumentCollection
    public final AssemblyRegionReadShardArgumentCollection shardingArgs = new AssemblyRegionReadShardArgumentCollection();
    @ArgumentCollection
    public final AssemblyRegionArgumentCollection assemblyRegionArgs = new AssemblyRegionArgumentCollection();
    @ArgumentCollection
    public ApplyBQSRUniqueArgumentCollection applyBqsrArgs = new ApplyBQSRUniqueArgumentCollection();
    @ArgumentCollection
    public HaplotypeCallerArgumentCollection hcArgs = new HaplotypeCallerArgumentCollection();
    @Argument(doc="whether to use the strict implementation or not (defaults to the faster implementation that doesn't strictly match the walker version)", fullName="strict", optional=true)
    public boolean strict = false;

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public boolean useVariantAnnotations() {
        return true;
    }

    @Override
    public List<Class<? extends Annotation>> getDefaultVariantAnnotationGroups() {
        return HaplotypeCallerEngine.getStandardHaplotypeCallerAnnotationGroups();
    }

    @Override
    public Collection<Annotation> makeVariantAnnotations() {
        boolean referenceConfidenceMode = this.hcArgs.emitReferenceConfidence != ReferenceConfidenceMode.NONE;
        Collection<Annotation> annotations = super.makeVariantAnnotations();
        return referenceConfidenceMode ? HaplotypeCallerEngine.filterReferenceConfidenceAnnotations(annotations) : annotations;
    }

    @Override
    protected void validateSequenceDictionaries() {
        if (!this.align) {
            super.validateSequenceDictionaries();
        }
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        SAMFileHeader header;
        JavaRDD alignedReads;
        BwaSparkEngine bwaEngine;
        String referenceFileName = ReadsPipelineSpark.addReferenceFilesForSpark(ctx, this.referenceArguments.getReferencePath());
        List<String> localKnownSitesFilePaths = ReadsPipelineSpark.addVCFsForSpark(ctx, this.knownVariants);
        if (this.align) {
            bwaEngine = new BwaSparkEngine(ctx, this.referenceArguments.getReferenceFileName(), this.bwaArgs.indexImageFile, this.getHeaderForReads(), this.getReferenceSequenceDictionary());
            if (this.bwaArgs.singleEndAlignment) {
                alignedReads = bwaEngine.alignUnpaired(this.getReads());
            } else {
                ReadFilter filter = this.makeReadFilter(bwaEngine.getHeader());
                alignedReads = bwaEngine.alignPaired(this.getUnfilteredReads()).filter(filter::test);
            }
            header = bwaEngine.getHeader();
        } else {
            bwaEngine = null;
            alignedReads = this.getReads();
            header = this.getHeaderForReads();
        }
        JavaRDD<GATKRead> markedReads = MarkDuplicatesSpark.mark(alignedReads, header, new OpticalDuplicateFinder(), this.markDuplicatesSparkArgumentCollection, this.getRecommendedNumReducers());
        SAMFileHeader readsHeader = header.clone();
        readsHeader.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        JavaRDD<GATKRead> sortedMarkedReads = SparkUtils.sortReadsAccordingToHeader(markedReads, readsHeader, this.numReducers);
        ReadFilter bqsrReadFilter = ReadFilter.fromList(BaseRecalibrator.getBQSRSpecificReadFilterList(), header);
        JavaRDD markedFilteredReadsForBQSR = sortedMarkedReads.filter(bqsrReadFilter::test);
        JavaPairRDD<GATKRead, Iterable<GATKVariant>> readsWithVariants = JoinReadsWithVariants.join((JavaRDD<GATKRead>)markedFilteredReadsForBQSR, localKnownSitesFilePaths);
        RecalibrationReport bqsrReport = BaseRecalibratorSparkFn.apply(readsWithVariants, this.getHeaderForReads(), referenceFileName, this.bqsrArgs);
        Broadcast reportBroadcast = ctx.broadcast((Object)bqsrReport);
        JavaRDD<GATKRead> finalReads = ApplyBQSRSparkFn.apply(sortedMarkedReads, (Broadcast<RecalibrationReport>)reportBroadcast, this.getHeaderForReads(), this.applyBqsrArgs.toApplyBQSRArgumentCollection(this.bqsrArgs));
        if (this.outputBam != null) {
            this.writeReads(ctx, this.outputBam, finalReads, header, true);
        }
        ReadFilter hcReadFilter = ReadFilter.fromList(HaplotypeCallerEngine.makeStandardHCReadFilters(), header);
        JavaRDD filteredReadsForHC = finalReads.filter(hcReadFilter::test);
        SAMSequenceDictionary sequenceDictionary = this.getBestAvailableSequenceDictionary();
        List<SimpleInterval> intervals = this.hasUserSuppliedIntervals() ? this.getIntervals() : IntervalUtils.getAllIntervalsForReference(sequenceDictionary);
        List<ShardBoundary> intervalShards = intervals.stream().flatMap(interval -> Shard.divideIntervalIntoShards(interval, this.shardingArgs.readShardSize, this.shardingArgs.readShardPadding, sequenceDictionary).stream()).collect(Collectors.toList());
        HaplotypeCallerSpark.callVariantsWithHaplotypeCallerAndWriteOutput(ctx, (JavaRDD<GATKRead>)filteredReadsForHC, readsHeader, sequenceDictionary, this.referenceArguments.getReferenceFileName(), intervalShards, this.hcArgs, this.shardingArgs, this.assemblyRegionArgs, this.output, this.makeVariantAnnotations(), this.logger, this.strict, this.createOutputVariantIndex);
        if (bwaEngine != null) {
            bwaEngine.close();
        }
    }
}

