/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pipelines;

import htsjdk.samtools.SAMFileHeader;
import java.util.Collections;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@DocumentedFeature
@CommandLineProgramProperties(summary="Sorts the input SAM/BAM/CRAM", oneLineSummary="SortSam on Spark (works on SAM/BAM/CRAM)", programGroup=ReadDataManipulationProgramGroup.class)
@BetaFeature
public final class SortSamSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    @Argument(doc="the output file path", shortName="O", fullName="output", optional=false)
    private String outputFile;
    @Argument(doc="sort order of the output file", shortName="SO", fullName="sort-order", optional=true)
    private SparkSortOrder sortOrder = SparkSortOrder.coordinate;

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return Collections.singletonList(ReadFilterLibrary.ALLOW_ALL_READS);
    }

    @Override
    protected void onStartup() {
        super.onStartup();
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        JavaRDD<GATKRead> reads = this.getReads();
        int numReducers = this.getRecommendedNumReducers();
        this.logger.info("Using {} reducers", new Object[]{numReducers});
        SAMFileHeader header = this.getHeaderForReads();
        header.setSortOrder(this.sortOrder.getSamOrder());
        this.writeReads(ctx, this.outputFile, reads, header, true);
    }

    private static enum SparkSortOrder {
        coordinate(SAMFileHeader.SortOrder.coordinate),
        queryname(SAMFileHeader.SortOrder.queryname);

        private final SAMFileHeader.SortOrder order;

        private SparkSortOrder(SAMFileHeader.SortOrder order) {
            this.order = order;
        }

        public SAMFileHeader.SortOrder getSamOrder() {
            return this.order;
        }
    }
}

