/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pipelines.metrics;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.MetricsReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.metrics.MetricsUtils;
import org.broadinstitute.hellbender.metrics.analysis.BaseDistributionByCycleMetrics;
import org.broadinstitute.hellbender.utils.R.RScriptExecutor;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.Resource;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;

@CommandLineProgramProperties(summary="Collects base distribution per cycle in SAM/BAM/CRAM file(s). The tool leverages the Spark framework for faster operation.", oneLineSummary="Collects base distribution per cycle in SAM/BAM/CRAM file(s).", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
@BetaFeature
public final class CollectBaseDistributionByCycleSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    @Argument(doc="Output metrics file.", shortName="O", fullName="output", optional=true)
    public String out;
    @Argument(shortName="C", fullName="chart", doc="Output charts file (pdf).", optional=true)
    public File chartOutput;
    @Argument(shortName="A", fullName="aligned-reads-only", doc="If set to true, calculates the base distribution over aligned reads only.")
    public boolean alignedReadsOnly = false;
    @Argument(shortName="F", fullName="pf-reads-only", doc="If set to true, calculates the base distribution over passing filter (PF) reads only.")
    public boolean pfReadsOnly = false;

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return Arrays.asList(ReadFilterLibrary.ALLOW_ALL_READS);
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        JavaRDD<GATKRead> reads = this.getReads();
        MetricsFile<BaseDistributionByCycleMetrics, Integer> metricsFile = this.calculateBaseDistributionByCycle(reads);
        this.saveResults(metricsFile, this.getHeaderForReads(), this.getReadSourceName());
    }

    public MetricsFile<BaseDistributionByCycleMetrics, Integer> calculateBaseDistributionByCycle(JavaRDD<GATKRead> reads) {
        MetricsReadFilter metricsFilter = new MetricsReadFilter(this.pfReadsOnly, this.alignedReadsOnly);
        JavaRDD filteredReads = reads.filter((Function & Serializable)read -> metricsFilter.test((GATKRead)read));
        HistogramGenerator hist = (HistogramGenerator)filteredReads.aggregate((Object)new HistogramGenerator(), (Function2 & Serializable)(hgp, read) -> hgp.addRead((GATKRead)read), (Function2 & Serializable)(hgp1, hgp2) -> hgp1.merge((HistogramGenerator)hgp2));
        MetricsFile metricsFile = this.getMetricsFile();
        hist.addToMetricsFile(metricsFile);
        return metricsFile;
    }

    protected void saveResults(MetricsFile<?, Integer> metrics, SAMFileHeader readsHeader, String inputFileName) {
        MetricsUtils.saveMetrics(metrics, this.out);
        if (metrics.getAllHistograms().isEmpty()) {
            this.logger.warn("No valid bases found in input file.");
        } else if (this.chartOutput != null) {
            List readGroups = readsHeader.getReadGroups();
            String plotSubtitle = "";
            if (readGroups.size() == 1) {
                plotSubtitle = StringUtil.asEmptyIfNull((Object)((SAMReadGroupRecord)readGroups.get(0)).getLibrary());
            }
            RScriptExecutor executor = new RScriptExecutor();
            executor.addScript(CollectBaseDistributionByCycleSpark.getBaseDistributionByCycleRScriptResource());
            executor.addArgs(this.out, this.chartOutput.getAbsolutePath(), inputFileName, plotSubtitle);
            executor.exec();
        }
    }

    @VisibleForTesting
    static Resource getBaseDistributionByCycleRScriptResource() {
        String R_SCRIPT = "baseDistributionByCycle.R";
        return new Resource("baseDistributionByCycle.R", CollectBaseDistributionByCycleSpark.class);
    }

    private static final class HistogramGenerator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final int NBASES = 5;
        private int maxLengthSoFar = 0;
        private final long[][] firstReadTotalsByCycle = new long[5][this.maxLengthSoFar];
        private long[] firstReadCountsByCycle = new long[this.maxLengthSoFar];
        private final long[][] secondReadTotalsByCycle = new long[5][this.maxLengthSoFar];
        private long[] secondReadCountsByCycle = new long[this.maxLengthSoFar];
        private boolean seenAnySecondOfPair = false;

        private HistogramGenerator() {
        }

        public HistogramGenerator merge(HistogramGenerator hg2) {
            int i;
            Utils.nonNull(hg2);
            this.ensureArraysBigEnough(hg2.maxLengthSoFar);
            for (i = 0; i < 5; ++i) {
                int j;
                for (j = 0; j < hg2.firstReadTotalsByCycle[i].length; ++j) {
                    long[] lArray = this.firstReadTotalsByCycle[i];
                    int n = j;
                    lArray[n] = lArray[n] + hg2.firstReadTotalsByCycle[i][j];
                }
                for (j = 0; j < hg2.secondReadTotalsByCycle[i].length; ++j) {
                    long[] lArray = this.secondReadTotalsByCycle[i];
                    int n = j;
                    lArray[n] = lArray[n] + hg2.secondReadTotalsByCycle[i][j];
                }
            }
            for (i = 0; i < hg2.firstReadCountsByCycle.length; ++i) {
                int n = i;
                this.firstReadCountsByCycle[n] = this.firstReadCountsByCycle[n] + hg2.firstReadCountsByCycle[i];
            }
            for (i = 0; i < hg2.secondReadCountsByCycle.length; ++i) {
                int n = i;
                this.secondReadCountsByCycle[n] = this.secondReadCountsByCycle[n] + hg2.secondReadCountsByCycle[i];
            }
            this.seenAnySecondOfPair = this.seenAnySecondOfPair || hg2.seenAnySecondOfPair;
            return this;
        }

        private int baseToInt(byte base) {
            switch (base) {
                case 65: 
                case 97: {
                    return 0;
                }
                case 67: 
                case 99: {
                    return 1;
                }
                case 71: 
                case 103: {
                    return 2;
                }
                case 84: 
                case 116: {
                    return 3;
                }
            }
            return 4;
        }

        HistogramGenerator addRead(GATKRead rec) {
            byte[] bases = rec.getBases();
            if (bases == null) {
                return this;
            }
            int length = bases.length;
            boolean rc = rec.isReverseStrand();
            this.ensureArraysBigEnough(length + 1);
            if (rec.isPaired() && rec.isSecondOfPair()) {
                this.seenAnySecondOfPair = true;
                for (int i = 0; i < length; ++i) {
                    int cycle = rc ? length - i : i + 1;
                    long[] lArray = this.secondReadTotalsByCycle[this.baseToInt(bases[i])];
                    int n = cycle;
                    lArray[n] = lArray[n] + 1L;
                    int n2 = cycle;
                    this.secondReadCountsByCycle[n2] = this.secondReadCountsByCycle[n2] + 1L;
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    int cycle = rc ? length - i : i + 1;
                    long[] lArray = this.firstReadTotalsByCycle[this.baseToInt(bases[i])];
                    int n = cycle;
                    lArray[n] = lArray[n] + 1L;
                    int n3 = cycle;
                    this.firstReadCountsByCycle[n3] = this.firstReadCountsByCycle[n3] + 1L;
                }
            }
            return this;
        }

        private void ensureArraysBigEnough(int length) {
            if (length > this.maxLengthSoFar) {
                for (int i = 0; i < 5; ++i) {
                    this.firstReadTotalsByCycle[i] = Arrays.copyOf(this.firstReadTotalsByCycle[i], length);
                    this.secondReadTotalsByCycle[i] = Arrays.copyOf(this.secondReadTotalsByCycle[i], length);
                }
                this.firstReadCountsByCycle = Arrays.copyOf(this.firstReadCountsByCycle, length);
                this.secondReadCountsByCycle = Arrays.copyOf(this.secondReadCountsByCycle, length);
                this.maxLengthSoFar = length;
            }
        }

        public void addToMetricsFile(MetricsFile<BaseDistributionByCycleMetrics, ?> metrics) {
            BaseDistributionByCycleMetrics metric;
            int i;
            int maxFirstReadCycles = 0;
            for (i = 0; i < this.maxLengthSoFar; ++i) {
                if (this.firstReadCountsByCycle[i] == 0L) continue;
                metric = new BaseDistributionByCycleMetrics();
                metric.READ_END = 1;
                metric.CYCLE = i;
                metric.PCT_A = 100.0 * (double)this.firstReadTotalsByCycle[0][i] / (double)this.firstReadCountsByCycle[i];
                metric.PCT_C = 100.0 * (double)this.firstReadTotalsByCycle[1][i] / (double)this.firstReadCountsByCycle[i];
                metric.PCT_G = 100.0 * (double)this.firstReadTotalsByCycle[2][i] / (double)this.firstReadCountsByCycle[i];
                metric.PCT_T = 100.0 * (double)this.firstReadTotalsByCycle[3][i] / (double)this.firstReadCountsByCycle[i];
                metric.PCT_N = 100.0 * (double)this.firstReadTotalsByCycle[4][i] / (double)this.firstReadCountsByCycle[i];
                metrics.addMetric((MetricBase)metric);
                maxFirstReadCycles = i;
            }
            if (this.seenAnySecondOfPair) {
                for (i = 0; i < this.maxLengthSoFar; ++i) {
                    if (this.secondReadCountsByCycle[i] == 0L) continue;
                    metric = new BaseDistributionByCycleMetrics();
                    metric.READ_END = 2;
                    metric.CYCLE = i + maxFirstReadCycles;
                    metric.PCT_A = 100.0 * (double)this.secondReadTotalsByCycle[0][i] / (double)this.secondReadCountsByCycle[i];
                    metric.PCT_C = 100.0 * (double)this.secondReadTotalsByCycle[1][i] / (double)this.secondReadCountsByCycle[i];
                    metric.PCT_G = 100.0 * (double)this.secondReadTotalsByCycle[2][i] / (double)this.secondReadCountsByCycle[i];
                    metric.PCT_T = 100.0 * (double)this.secondReadTotalsByCycle[3][i] / (double)this.secondReadCountsByCycle[i];
                    metric.PCT_N = 100.0 * (double)this.secondReadTotalsByCycle[4][i] / (double)this.secondReadCountsByCycle[i];
                    metrics.addMetric((MetricBase)metric);
                }
            }
        }
    }
}

