/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pipelines.metrics;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.metrics.Header;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.argumentcollections.MetricAccumulationLevelArgumentCollection;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.metrics.InsertSizeMetrics;
import org.broadinstitute.hellbender.metrics.InsertSizeMetricsArgumentCollection;
import org.broadinstitute.hellbender.metrics.MetricAccumulationLevel;
import org.broadinstitute.hellbender.metrics.MetricsArgumentCollection;
import org.broadinstitute.hellbender.metrics.QualityYieldMetrics;
import org.broadinstitute.hellbender.metrics.QualityYieldMetricsArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.pipelines.metrics.InsertSizeMetricsCollectorSpark;
import org.broadinstitute.hellbender.tools.spark.pipelines.metrics.MetricsCollectorSpark;
import org.broadinstitute.hellbender.tools.spark.pipelines.metrics.QualityYieldMetricsCollectorSpark;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;

@CommandLineProgramProperties(summary="Instantiates and executes multiple metrics collection tasks for a given SAM/BAM/CRAM file. The tool leverages the Spark framework for faster operation. Importantly, the aligned reads are loaded into a Spark RDD only once, and the same RDD is used for each metric collection tasks to cut down on I/O time. Currently all programs are run  with default options and fixed output extensions.", oneLineSummary="Runs multiple metrics collection modules for a given alignment file", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
@BetaFeature
public final class CollectMultipleMetricsSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    @Argument(doc="If true (default), then the sort order in the header file will be ignored.", fullName="assume-sorted", shortName="AS")
    public boolean ASSUME_SORTED = true;
    @Argument(doc="Base name of output files.", fullName="output", shortName="O")
    public String outputBaseName;
    @ArgumentCollection
    MetricAccumulationLevelArgumentCollection metricAccumulationLevel = new MetricAccumulationLevelArgumentCollection();
    @Argument(fullName="collectors", doc="List of metrics collectors to apply during the pass through the SAM file. If no collectors are specified than all collectors will be run", optional=true)
    public List<SparkCollectors> userCollectors = new ArrayList<SparkCollectors>();
    private List<SparkCollectorProvider> externalCollectors = null;

    public void setCollectorsToRun(List<SparkCollectorProvider> externalCollectorsToRun) {
        this.externalCollectors = externalCollectorsToRun;
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        JavaRDD<GATKRead> unFilteredReads = this.getUnfilteredReads();
        List<SparkCollectorProvider> collectorsToRun = this.getCollectorsToRun();
        if (collectorsToRun.size() > 1) {
            unFilteredReads.cache();
        }
        for (SparkCollectorProvider provider : collectorsToRun) {
            MetricsCollectorSpark<? extends MetricsArgumentCollection> metricsCollector = provider.createCollector(this.outputBaseName, this.metricAccumulationLevel.accumulationLevels, this.getDefaultHeaders(), this.getHeaderForReads());
            this.validateCollector(metricsCollector, collectorsToRun.get(collectorsToRun.indexOf(provider)).getClass().getName());
            ReadFilter readFilter = ReadFilter.fromList(metricsCollector.getDefaultReadFilters(), this.getHeaderForReads());
            metricsCollector.collectMetrics((JavaRDD<GATKRead>)unFilteredReads.filter((Function & Serializable)r -> readFilter.test((GATKRead)r)), this.getHeaderForReads());
            metricsCollector.saveMetrics(this.getReadSourceName());
        }
    }

    private List<SparkCollectorProvider> getCollectorsToRun() {
        if (this.externalCollectors == null) {
            if (this.userCollectors.size() == 0) {
                return Arrays.asList(SparkCollectors.values());
            }
            ArrayList<SparkCollectorProvider> collectorsToRun = new ArrayList<SparkCollectorProvider>();
            collectorsToRun.addAll(this.userCollectors);
            return collectorsToRun;
        }
        return this.externalCollectors;
    }

    private void validateCollector(MetricsCollectorSpark<?> collector, String sourceName) {
        if (collector.requiresReference()) {
            throw new UnsupportedOperationException("Requires reference for collector not yet implemented");
        }
        ReadUtils.validateExpectedSortOrder(this.getHeaderForReads().getSortOrder(), collector.getExpectedSortOrder(), false, sourceName);
    }

    public static enum SparkCollectors implements SparkCollectorProvider
    {
        CollectInsertSizeMetrics{

            @Override
            public MetricsCollectorSpark<? extends MetricsArgumentCollection> createCollector(String outputBaseName, Set<MetricAccumulationLevel> metricAccumulationLevel, List<Header> defaultHeaders, SAMFileHeader samHeader) {
                String localBaseName = outputBaseName + "." + InsertSizeMetrics.getUniqueNameSuffix();
                InsertSizeMetricsArgumentCollection isArgs = new InsertSizeMetricsArgumentCollection();
                isArgs.output = localBaseName + ".txt";
                isArgs.histogramPlotFile = localBaseName + ".pdf";
                isArgs.metricAccumulationLevel.accumulationLevels = metricAccumulationLevel;
                InsertSizeMetricsCollectorSpark collector = new InsertSizeMetricsCollectorSpark();
                collector.initialize(isArgs, samHeader, defaultHeaders);
                return collector;
            }
        }
        ,
        CollectQualityYieldMetrics{

            @Override
            public MetricsCollectorSpark<? extends MetricsArgumentCollection> createCollector(String outputBaseName, Set<MetricAccumulationLevel> metricAccumulationLevel, List<Header> defaultHeaders, SAMFileHeader samHeader) {
                String localBaseName = outputBaseName + "." + QualityYieldMetrics.getUniqueNameSuffix();
                QualityYieldMetricsArgumentCollection qyArgs = new QualityYieldMetricsArgumentCollection();
                qyArgs.output = localBaseName + ".txt";
                QualityYieldMetricsCollectorSpark collector = new QualityYieldMetricsCollectorSpark();
                collector.initialize(qyArgs, samHeader, defaultHeaders);
                return collector;
            }
        };

    }

    public static interface SparkCollectorProvider {
        public MetricsCollectorSpark<? extends MetricsArgumentCollection> createCollector(String var1, Set<MetricAccumulationLevel> var2, List<Header> var3, SAMFileHeader var4);
    }
}

