/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pipelines.metrics;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.metrics.Header;
import htsjdk.samtools.metrics.MetricsFile;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.metrics.InsertSizeMetrics;
import org.broadinstitute.hellbender.metrics.InsertSizeMetricsArgumentCollection;
import org.broadinstitute.hellbender.metrics.InsertSizeMetricsCollector;
import org.broadinstitute.hellbender.tools.spark.pipelines.metrics.MetricsCollectorSpark;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class InsertSizeMetricsCollectorSpark
implements MetricsCollectorSpark<InsertSizeMetricsArgumentCollection>,
Serializable {
    private static final long serialVersionUID = 1L;
    private InsertSizeMetricsArgumentCollection inputArgs = null;
    private InsertSizeMetricsCollector collector = new InsertSizeMetricsCollector();
    private InsertSizeMetricsCollector resultMetrics = null;
    private MetricsFile<InsertSizeMetrics, Integer> metricsFile = null;

    @Override
    public void initialize(InsertSizeMetricsArgumentCollection inputArgs, SAMFileHeader samHeader, List<Header> defaultHeaders) {
        this.inputArgs = inputArgs;
        this.collector.initialize(inputArgs, samHeader);
        this.metricsFile = new MetricsFile();
        if (defaultHeaders != null) {
            defaultHeaders.stream().forEach(h -> this.metricsFile.addHeader(h));
        }
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return this.collector.getDefaultReadFilters();
    }

    @Override
    public void collectMetrics(JavaRDD<GATKRead> filteredReads, SAMFileHeader samHeader) {
        if (filteredReads.isEmpty()) {
            throw new GATKException("No valid reads found in input file.");
        }
        this.resultMetrics = (InsertSizeMetricsCollector)filteredReads.mapPartitions((FlatMapFunction & Serializable)it -> {
            it.forEachRemaining(r -> this.collector.acceptRecord(r.convertToSAMRecord(samHeader), null));
            return Arrays.asList(this.collector).iterator();
        }).reduce(this.collector::combine);
    }

    @Override
    public void saveMetrics(String inputName) {
        this.resultMetrics.finish(this.metricsFile, inputName);
    }
}

