/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pipelines.metrics;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.metrics.Header;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.metrics.MetricsArgumentCollection;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public abstract class MetricsCollectorSparkTool<T extends MetricsArgumentCollection>
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;

    @Override
    public abstract List<ReadFilter> getDefaultReadFilters();

    protected abstract SAMFileHeader.SortOrder getExpectedSortOrder();

    protected abstract void initialize(T var1, SAMFileHeader var2, List<Header> var3);

    protected abstract void collectMetrics(JavaRDD<GATKRead> var1, SAMFileHeader var2);

    protected abstract void saveMetrics(String var1);

    protected abstract T getInputArguments();

    @Override
    public final boolean requiresReads() {
        return true;
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        if (this.requiresReference()) {
            throw new UnsupportedOperationException("Requires reference for collector not yet implemented");
        }
        ReadUtils.validateExpectedSortOrder(this.getHeaderForReads().getSortOrder(), this.getExpectedSortOrder(), false, this.getReadSourceName());
        T collectorArgs = this.getInputArguments();
        if (null == collectorArgs) {
            throw new IllegalStateException("A Spark metrics collector must return a non-a null argument object");
        }
        this.initialize(collectorArgs, this.getHeaderForReads(), this.getDefaultHeaders());
        JavaRDD<GATKRead> filteredReads = this.getReads();
        this.collectMetrics(filteredReads, this.getHeaderForReads());
        this.saveMetrics(this.getReadSourceName());
    }
}

