/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.pipelines.metrics;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.metrics.Header;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import java.io.Serializable;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function2;
import org.broadinstitute.hellbender.metrics.MetricsUtils;
import org.broadinstitute.hellbender.metrics.QualityYieldMetrics;
import org.broadinstitute.hellbender.metrics.QualityYieldMetricsArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.pipelines.metrics.MetricsCollectorSpark;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class QualityYieldMetricsCollectorSpark
implements MetricsCollectorSpark<QualityYieldMetricsArgumentCollection>,
Serializable {
    private static final long serialVersionUID = 1L;
    private QualityYieldMetricsArgumentCollection args = null;
    private MetricsFile<QualityYieldMetrics, Integer> metricsFile = null;

    @Override
    public void initialize(QualityYieldMetricsArgumentCollection inputArgs, SAMFileHeader samHeader, List<Header> defaultHeaders) {
        this.metricsFile = new MetricsFile();
        defaultHeaders.stream().forEach(h -> this.metricsFile.addHeader(h));
        this.args = inputArgs;
    }

    @Override
    public void collectMetrics(JavaRDD<GATKRead> filteredReads, SAMFileHeader samHeader) {
        QualityYieldMetrics metrics = ((QualityYieldMetrics)filteredReads.aggregate((Object)new QualityYieldMetrics().setUseOriginalQualities(this.args.useOriginalQualities), (Function2 & Serializable)(hgp, read) -> hgp.addRead((GATKRead)read), (Function2 & Serializable)(hgp1, hgp2) -> hgp1.combine((QualityYieldMetrics)hgp2))).finish();
        this.metricsFile.addMetric((MetricBase)metrics);
    }

    @Override
    public void saveMetrics(String inputBaseName) {
        MetricsUtils.saveMetrics(this.metricsFile, this.args.output);
    }
}

