/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.spark.sv.InsertSizeDistributionShape;

public class InsertSizeDistribution
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Pattern DESCRIPTION_PATTERN = Pattern.compile("^\\s*(?<name>[^\\s\\(\\)]+)\\s*\\((?<mean>[^,\\(\\)]+?)\\s*(?:,\\s*(?<stddev>[^,\\(\\)]+?)\\s*)?\\)\\s*");
    private final String description;
    private transient AbstractIntegerDistribution dist;

    private AbstractIntegerDistribution dist() {
        this.initializeDistribution();
        return this.dist;
    }

    public double mean() {
        return this.dist().getNumericalMean();
    }

    public double variance() {
        return this.dist().getNumericalVariance();
    }

    public double stddev() {
        return Math.sqrt(this.variance());
    }

    public InsertSizeDistribution(String distrString) {
        this.description = distrString;
        this.initializeDistribution();
    }

    private void initializeDistribution() {
        if (!this.description.matches(DESCRIPTION_PATTERN.pattern())) {
            throw new UserException.BadInput("unsupported insert size distribution description format: " + this.description);
        }
        Matcher matcher = DESCRIPTION_PATTERN.matcher(this.description);
        if (!matcher.find()) {
            throw new UserException.BadInput("the insert-size distribution spec is not up to standard: " + this.description);
        }
        String nameString = matcher.group("name");
        String meanString = matcher.group("mean");
        String stddevString = matcher.group("stddev");
        InsertSizeDistributionShape type = InsertSizeDistribution.extractDistributionShape(nameString, this.description);
        if (stddevString != null) {
            double mean = InsertSizeDistribution.extractDoubleParameter("mean", this.description, meanString, 0.0, Double.MAX_VALUE);
            double stddev = InsertSizeDistribution.extractDoubleParameter("stddev", this.description, stddevString, 0.0, Double.MAX_VALUE);
            this.dist = type.fromMeanAndStdDeviation(mean, stddev);
        } else {
            this.dist = type.fromReadMetadataFile(meanString);
        }
    }

    private static InsertSizeDistributionShape extractDistributionShape(String nameString, String description) {
        InsertSizeDistributionShape result = InsertSizeDistributionShape.decode(nameString);
        if (result == null) {
            throw new UserException.BadInput("unsupported insert size distribution name '" + nameString + "' in description: " + description);
        }
        return result;
    }

    private static double extractDoubleParameter(String name, String description, String valueString, double min, double max) {
        double value;
        try {
            value = Double.parseDouble(valueString);
        }
        catch (NumberFormatException ex) {
            throw new UserException.BadInput("bad " + name + " string '" + valueString + "' in insert size distribution description: " + description);
        }
        if (value < min || Double.isInfinite(value) || Double.isNaN(value) || value > max) {
            throw new UserException.BadInput("bad " + name + " value '" + value + "' in insert size distribution description: " + description);
        }
        return value;
    }

    public String toString() {
        return this.description;
    }

    public int hashCode() {
        return this.dist().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InsertSizeDistribution)) {
            return false;
        }
        return ((InsertSizeDistribution)obj).dist().equals(this.dist());
    }

    public int minimum() {
        return Math.max(0, this.dist().getSupportLowerBound());
    }

    public int maximum() {
        return Math.min(Integer.MAX_VALUE, this.dist().getSupportUpperBound());
    }

    public double probability(int size) {
        return this.dist().probability(size);
    }

    public double logProbability(int size) {
        return this.dist().logProbability(size);
    }
}

