/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.apache.commons.math3.distribution.LogNormalDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.LibraryStatistics;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadMetadata;
import org.broadinstitute.hellbender.tools.spark.utils.IntHistogram;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;

public enum InsertSizeDistributionShape {
    NORMAL(new String[]{"N", "Gauss", "Gaussian"}){

        @Override
        public AbstractIntegerDistribution fromMeanAndStdDeviation(double mean, double stddev) {
            int seed = Double.hashCode(mean) * 31 + Double.hashCode(stddev) * 31 + this.name().hashCode() * 31;
            JDKRandomGenerator rdnGen = new JDKRandomGenerator();
            rdnGen.setSeed(seed);
            NormalDistribution normal = new NormalDistribution(mean, stddev);
            double zeroCumulative = normal.cumulativeProbability(-0.5);
            double zeroProb = normal.density(0.0);
            final double normalization = 1.0 / (1.0 - zeroCumulative);
            double mu = normal.getNumericalMean();
            double sigmaSquare = normal.getNumericalVariance();
            double sigma = Math.sqrt(sigmaSquare);
            double newMean = mu + sigma * zeroProb * normalization;
            double newVariance = sigmaSquare * (1.0 + normalization * (-mu / sigma) * zeroProb - Math.pow(zeroProb * normalization, 2.0));
            return new AbstractIntegerDistribution((RandomGenerator)rdnGen, (RealDistribution)normal, zeroCumulative, newMean, newVariance){
                private static final long serialVersionUID = -1L;
                final /* synthetic */ RealDistribution val$normal;
                final /* synthetic */ double val$zeroCumulative;
                final /* synthetic */ double val$newMean;
                final /* synthetic */ double val$newVariance;
                {
                    this.val$normal = realDistribution;
                    this.val$zeroCumulative = d2;
                    this.val$newMean = d3;
                    this.val$newVariance = d4;
                    super(x0);
                }

                public double probability(int x) {
                    return normalization * (this.val$normal.cumulativeProbability((double)x + 0.5) - this.val$normal.cumulativeProbability((double)x - 0.5));
                }

                public double cumulativeProbability(int x) {
                    return (this.val$normal.cumulativeProbability((double)x + 0.5) - this.val$zeroCumulative) * normalization;
                }

                public double getNumericalMean() {
                    return this.val$newMean;
                }

                public double getNumericalVariance() {
                    return this.val$newVariance;
                }

                public int getSupportLowerBound() {
                    return 0;
                }

                public int getSupportUpperBound() {
                    return Integer.MAX_VALUE;
                }

                public boolean isSupportConnected() {
                    return true;
                }
            };
        }

        @Override
        public AbstractIntegerDistribution fromSerializationFile(String whereFrom) {
            ReadMetadata metaData = ReadMetadata.Serializer.readStandalone(whereFrom);
            IntHistogram hist = new IntHistogram(2000);
            long modeCount = 0L;
            for (LibraryStatistics libStats : metaData.getAllLibraryStatistics().values()) {
                IntHistogram.CDF cdf = libStats.getCDF();
                long cdfTotalCount = cdf.getTotalObservations();
                int size = cdf.size() - 1;
                hist.addObservations(0, Math.round(cdf.getFraction(0) * (float)cdfTotalCount));
                for (int i = 1; i < size; ++i) {
                    double fraction = cdf.getFraction(i) - cdf.getFraction(i - 1);
                    long count = Math.round(fraction * (double)cdfTotalCount);
                    if (modeCount < count) {
                        modeCount = count;
                    }
                    hist.addObservations(i, count);
                }
            }
            if (hist.getTotalObservations() == 0L) {
                throw new UserException.MalformedFile("Could not find any insert-sizes in " + whereFrom);
            }
            return hist.empiricalDistribution((int)Math.max(1L, modeCount / 1000000L));
        }
    }
    ,
    LOG_NORMAL(new String[]{"LogNormal", "LnN"}){

        @Override
        public AbstractIntegerDistribution fromMeanAndStdDeviation(double mean, double stddev) {
            double var = stddev * stddev;
            double scale = 2.0 * Math.log(mean) - 0.5 * Math.log(var + mean * mean);
            double shape = Math.sqrt(Math.log(1.0 + var / (mean * mean)));
            LogNormalDistribution real = new LogNormalDistribution(scale, shape);
            int seed = Double.hashCode(mean) * 31 + Double.hashCode(stddev) * 31 + this.name().hashCode() * 31;
            JDKRandomGenerator rdnGen = new JDKRandomGenerator();
            rdnGen.setSeed(seed);
            return new AbstractIntegerDistribution((RandomGenerator)rdnGen, (RealDistribution)real){
                private static final long serialVersionUID = -1L;
                final /* synthetic */ RealDistribution val$real;
                {
                    this.val$real = realDistribution;
                    super(x0);
                }

                public double probability(int x) {
                    return this.val$real.cumulativeProbability((double)x + 0.5) - this.val$real.cumulativeProbability((double)x - 0.5);
                }

                public double cumulativeProbability(int x) {
                    return this.val$real.cumulativeProbability((double)x + 0.5);
                }

                public double getNumericalMean() {
                    return this.val$real.getNumericalMean();
                }

                public double getNumericalVariance() {
                    return this.val$real.getNumericalVariance();
                }

                public int getSupportLowerBound() {
                    return 0;
                }

                public int getSupportUpperBound() {
                    return Integer.MAX_VALUE;
                }

                public boolean isSupportConnected() {
                    return true;
                }
            };
        }
    }
    ,
    EMPIRICAL(new String[]{"E", "Emp"}){

        @Override
        public AbstractIntegerDistribution fromMeanAndStdDeviation(double mean, double stddev) {
            throw new UserException.BadInput("Empirical insert-size-distribution needs a meta-file");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public AbstractIntegerDistribution fromTextFile(String whereFrom) {
            IntHistogram hist = new IntHistogram(2000);
            long modeCount = 0L;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(BucketUtils.openFile(whereFrom)));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith("template size cumulative counts:")) continue;
                    String[] cdf = line.substring("template size cumulative counts:".length() + 1).split("\t");
                    long leftCdf = 0L;
                    for (int value = 0; value < cdf.length; ++value) {
                        long frequency = Long.parseLong(cdf[value]) - leftCdf;
                        hist.addObservations(value, frequency);
                        if (hist.getNObservations(value) <= modeCount) continue;
                        modeCount = hist.getNObservations(value);
                    }
                }
                if (hist.getTotalObservations() == 0L) {
                    throw new UserException.MalformedFile("Could not find any insert-sizes in " + whereFrom);
                }
                AbstractIntegerDistribution abstractIntegerDistribution = hist.empiricalDistribution((int)Math.max(1L, modeCount / 1000000L));
                return abstractIntegerDistribution;
            }
            catch (IOException ex) {
                throw new UserException.CouldNotReadInputFile(whereFrom);
            }
        }
    };

    private final List<String> aliases;
    private static final Map<String, InsertSizeDistributionShape> byLowercaseName;

    private InsertSizeDistributionShape(String ... names) {
        List<String> nameList = Arrays.asList(names);
        this.aliases = Collections.unmodifiableList(nameList);
    }

    public List<String> aliases() {
        return this.aliases;
    }

    public static InsertSizeDistributionShape decode(String name) {
        Utils.nonNull(name);
        return byLowercaseName.get(name.toLowerCase());
    }

    protected abstract AbstractIntegerDistribution fromMeanAndStdDeviation(double var1, double var3);

    protected AbstractIntegerDistribution fromReadMetadataFile(String whereFrom) {
        try {
            return this.fromSerializationFile(whereFrom);
        }
        catch (RuntimeException ex) {
            return this.fromTextFile(whereFrom);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AbstractIntegerDistribution fromTextFile(String whereFrom) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(BucketUtils.openFile(whereFrom)));){
            String line;
            double totalSum = 0.0;
            double totalSqSum = 0.0;
            long totalCount = 0L;
            while ((line = reader.readLine()) != null) {
                long frequency;
                if (!line.startsWith("template size cumulative counts:")) continue;
                String[] cdf = line.substring("template size cumulative counts:".length() + 1).split("\t");
                long leftCdf = 0L;
                for (int value = 0; value < cdf.length; leftCdf += frequency, totalSum += (double)(frequency * (long)value), totalSqSum += (double)((long)(value * value) * frequency), ++value) {
                    frequency = Long.parseLong(cdf[value]) - leftCdf;
                }
                totalCount += leftCdf;
            }
            if (totalCount == 0L) {
                throw new UserException.MalformedFile("Could not find any insert-sizes in " + whereFrom);
            }
            double mean = totalSum / (double)totalCount;
            double stdDev = Math.sqrt(Math.abs(totalSqSum / (double)totalCount - mean * mean));
            AbstractIntegerDistribution abstractIntegerDistribution = this.fromMeanAndStdDeviation(mean, stdDev);
            return abstractIntegerDistribution;
        }
        catch (IOException ex2) {
            throw new UserException.CouldNotReadInputFile(whereFrom);
        }
        catch (NumberFormatException ex2) {
            throw new UserException.MalformedFile("the CDF contains non-numbers in " + whereFrom);
        }
    }

    protected AbstractIntegerDistribution fromSerializationFile(String whereFrom) {
        ReadMetadata metaData = ReadMetadata.Serializer.readStandalone(whereFrom);
        double totalSum = 0.0;
        double totalSqSum = 0.0;
        long totalCount = 0L;
        for (LibraryStatistics libStats : metaData.getAllLibraryStatistics().values()) {
            IntHistogram.CDF cdf = libStats.getCDF();
            long cdfTotalCount = cdf.getTotalObservations();
            int size = cdf.size();
            for (int i = 1; i < size; ++i) {
                double fraction = cdf.getFraction(i) - cdf.getFraction(i - 1);
                double count = fraction * (double)cdfTotalCount;
                totalSum += count * (double)i;
                totalSqSum += count * (double)i * (double)i;
            }
            totalCount += cdfTotalCount;
        }
        if (totalCount == 0L) {
            throw new UserException.MalformedFile("Could not find any insert-sizes in " + whereFrom);
        }
        double mean = totalSum / (double)totalCount;
        double variance = Math.abs(totalSqSum / (double)totalCount - mean * mean);
        double stdDev = Math.sqrt(variance);
        return this.fromMeanAndStdDeviation(mean, stdDev);
    }

    static {
        InsertSizeDistributionShape[] shapes = InsertSizeDistributionShape.values();
        byLowercaseName = new HashMap<String, InsertSizeDistributionShape>(shapes.length * 6);
        for (InsertSizeDistributionShape shape : shapes) {
            byLowercaseName.put(shape.name().toLowerCase(), shape);
            for (String alias : shape.aliases) {
                byLowercaseName.put(alias.toLowerCase(), shape);
            }
        }
    }
}

