/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.variant.variantcontext.StructuralVariantType;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.tools.spark.sv.StructuralVariationDiscoveryArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SVAlignmentLengthFilter;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SVMappingQualityFilter;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.StructuralVariantFilter;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SvType;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.EvidenceTargetLink;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadMetadata;
import org.broadinstitute.hellbender.tools.spark.sv.utils.PairedStrandedIntervalTree;
import org.broadinstitute.hellbender.tools.spark.sv.utils.PairedStrandedIntervals;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVContext;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.StrandedInterval;
import org.broadinstitute.hellbender.utils.Utils;
import scala.Tuple2;

public class AnnotatedVariantProducer
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static VariantContext produceAnnotatedVcFromEvidenceTargetLink(EvidenceTargetLink evidenceTargetLink, SvType svType) {
        PairedStrandedIntervals pairedStrandedIntervals = evidenceTargetLink.getPairedStrandedIntervals();
        StrandedInterval strandedIntervalLeft = pairedStrandedIntervals.getLeft();
        StrandedInterval strandedIntervalRight = pairedStrandedIntervals.getRight();
        int start = strandedIntervalLeft.getInterval().midpoint();
        int end = strandedIntervalRight.getInterval().midpoint();
        VariantContextBuilder builder = svType.getBasicInformation().attribute("CIPOS", (Object)AnnotatedVariantProducer.produceCIInterval(start, strandedIntervalLeft.getInterval())).attribute("CIEND", (Object)AnnotatedVariantProducer.produceCIInterval(end, strandedIntervalRight.getInterval())).attribute("READ_PAIR_SUPPORT", (Object)evidenceTargetLink.getReadPairs()).attribute("SPLIT_READ_SUPPORT", (Object)evidenceTargetLink.getSplitReads());
        return builder.make();
    }

    public static List<VariantContext> annotateBreakpointBasedCallsWithImpreciseEvidenceLinks(List<VariantContext> assemblyDiscoveredVariants, PairedStrandedIntervalTree<EvidenceTargetLink> evidenceTargetLinks, ReadMetadata metadata, SAMSequenceDictionary refDict, StructuralVariationDiscoveryArgumentCollection.DiscoverVariantsFromContigAlignmentsArgumentCollection parameters, Logger localLogger) {
        int originalEvidenceLinkSize = evidenceTargetLinks.size();
        List<VariantContext> result = assemblyDiscoveredVariants.stream().map(variant -> AnnotatedVariantProducer.annotateWithImpreciseEvidenceLinks(variant, evidenceTargetLinks, refDict, metadata, parameters.assemblyImpreciseEvidenceOverlapUncertainty)).collect(Collectors.toList());
        localLogger.info("Used " + (originalEvidenceLinkSize - evidenceTargetLinks.size()) + " evidence target links to annotate assembled breakpoints");
        return result;
    }

    private static VariantContext annotateWithImpreciseEvidenceLinks(VariantContext variant, PairedStrandedIntervalTree<EvidenceTargetLink> evidenceTargetLinks, SAMSequenceDictionary referenceSequenceDictionary, ReadMetadata metadata, int defaultUncertainty) {
        if (variant.getStructuralVariantType() == StructuralVariantType.DEL) {
            SVContext svc = SVContext.of(variant);
            int padding = metadata == null ? defaultUncertainty : metadata.getMaxMedianFragmentSize() / 2;
            PairedStrandedIntervals svcIntervals = svc.getPairedStrandedIntervals(metadata, referenceSequenceDictionary, padding);
            Iterator<Tuple2<PairedStrandedIntervals, EvidenceTargetLink>> overlappers = evidenceTargetLinks.overlappers(svcIntervals);
            int readPairs = 0;
            int splitReads = 0;
            while (overlappers.hasNext()) {
                Tuple2<PairedStrandedIntervals, EvidenceTargetLink> next = overlappers.next();
                readPairs += ((EvidenceTargetLink)next._2).getReadPairs();
                splitReads += ((EvidenceTargetLink)next._2).getSplitReads();
                overlappers.remove();
            }
            VariantContextBuilder variantContextBuilder = new VariantContextBuilder(variant);
            if (readPairs > 0) {
                variantContextBuilder.attribute("READ_PAIR_SUPPORT", (Object)readPairs);
            }
            if (splitReads > 0) {
                variantContextBuilder.attribute("SPLIT_READ_SUPPORT", (Object)splitReads);
            }
            return variantContextBuilder.make();
        }
        return variant;
    }

    @VisibleForTesting
    static String produceCIInterval(int point, SVInterval ciInterval) {
        Utils.validate(ciInterval.getStart() <= point && ciInterval.getEnd() >= point, "Interval must contain point");
        return String.join((CharSequence)",", String.valueOf(ciInterval.getStart() - point), String.valueOf(ciInterval.getEnd() - point));
    }

    public static List<VariantContext> filterMergedVariantList(List<VariantContext> variants, StructuralVariationDiscoveryArgumentCollection.DiscoverVariantsFromContigAlignmentsArgumentCollection discoveryArgs) {
        ArrayList<VariantContext> variantsWithFilterApplied = new ArrayList<VariantContext>(variants.size());
        List<StructuralVariantFilter> filters = Arrays.asList(new SVMappingQualityFilter(discoveryArgs.minMQ), new SVAlignmentLengthFilter(discoveryArgs.minAlignLength));
        for (VariantContext variant : variants) {
            String svType = variant.getAttributeAsString("SVTYPE", "");
            if ((svType.equals("DEL") || svType.equals("INS") || svType.equals("DUP")) && Math.abs(variant.getAttributeAsInt("SVLEN", 0)) < 50) continue;
            variantsWithFilterApplied.add(AnnotatedVariantProducer.applyFilters(variant, filters));
        }
        return variantsWithFilterApplied;
    }

    private static VariantContext applyFilters(VariantContext variantContext, List<StructuralVariantFilter> filters) {
        HashSet<String> appliedFilters = new HashSet<String>();
        for (StructuralVariantFilter filter : filters) {
            if (filter.test(variantContext)) continue;
            appliedFilters.add(filter.getName());
        }
        if (appliedFilters.isEmpty()) {
            return variantContext;
        }
        return new VariantContextBuilder(variantContext).filters(appliedFilters).make();
    }
}

